/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.TapeDriveType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutTapeDensityDirectiveSpectraS3Request
extends AbstractRequest {
    private final TapeDriveType density;
    private final String partitionId;
    private final String tapeType;

    public PutTapeDensityDirectiveSpectraS3Request(TapeDriveType density, UUID partitionId, String tapeType) {
        this.density = density;
        this.partitionId = partitionId.toString();
        this.tapeType = tapeType;
        this.updateQueryParam("density", density);
        this.updateQueryParam("partition_id", partitionId);
        this.updateQueryParam("tape_type", tapeType);
    }

    public PutTapeDensityDirectiveSpectraS3Request(TapeDriveType density, String partitionId, String tapeType) {
        this.density = density;
        this.partitionId = partitionId;
        this.tapeType = tapeType;
        this.updateQueryParam("density", density);
        this.updateQueryParam("partition_id", partitionId);
        this.updateQueryParam("tape_type", tapeType);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape_density_directive";
    }

    public TapeDriveType getDensity() {
        return this.density;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getTapeType() {
        return this.tapeType;
    }
}

