/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.StorageDomainMemberState;
import com.spectralogic.ds3client.models.WritePreferenceLevel;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetStorageDomainMembersSpectraS3Request
extends AbstractPaginationRequest {
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String poolPartitionId;
    private StorageDomainMemberState state;
    private String storageDomainId;
    private String tapePartitionId;
    private String tapeType;
    private WritePreferenceLevel writePreference;

    public GetStorageDomainMembersSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withPoolPartitionId(UUID poolPartitionId) {
        this.poolPartitionId = poolPartitionId.toString();
        this.updateQueryParam("pool_partition_id", poolPartitionId);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withPoolPartitionId(String poolPartitionId) {
        this.poolPartitionId = poolPartitionId;
        this.updateQueryParam("pool_partition_id", poolPartitionId);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withState(StorageDomainMemberState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withTapePartitionId(UUID tapePartitionId) {
        this.tapePartitionId = tapePartitionId.toString();
        this.updateQueryParam("tape_partition_id", tapePartitionId);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withTapePartitionId(String tapePartitionId) {
        this.tapePartitionId = tapePartitionId;
        this.updateQueryParam("tape_partition_id", tapePartitionId);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withTapeType(String tapeType) {
        this.tapeType = tapeType;
        this.updateQueryParam("tape_type", tapeType);
        return this;
    }

    public GetStorageDomainMembersSpectraS3Request withWritePreference(WritePreferenceLevel writePreference) {
        this.writePreference = writePreference;
        this.updateQueryParam("write_preference", writePreference);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/storage_domain_member";
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getPoolPartitionId() {
        return this.poolPartitionId;
    }

    public StorageDomainMemberState getState() {
        return this.state;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public String getTapePartitionId() {
        return this.tapePartitionId;
    }

    public String getTapeType() {
        return this.tapeType;
    }

    public WritePreferenceLevel getWritePreference() {
        return this.writePreference;
    }
}

