/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.FeatureKeyType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.Date;
import java.util.UUID;

public class GetFeatureKeysSpectraS3Request
extends AbstractPaginationRequest {
    private String errorMessage;
    private Date expirationDate;
    private FeatureKeyType key;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;

    public GetFeatureKeysSpectraS3Request withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.updateQueryParam("error_message", errorMessage);
        return this;
    }

    public GetFeatureKeysSpectraS3Request withExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        this.updateQueryParam("expiration_date", expirationDate);
        return this;
    }

    public GetFeatureKeysSpectraS3Request withKey(FeatureKeyType key) {
        this.key = key;
        this.updateQueryParam("key", key);
        return this;
    }

    public GetFeatureKeysSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetFeatureKeysSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetFeatureKeysSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetFeatureKeysSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetFeatureKeysSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/feature_key";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public FeatureKeyType getKey() {
        return this.key;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }
}

