/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetBucketHistorySpectraS3Request
extends AbstractPaginationRequest {
    private String bucketId;
    private boolean lastPage;
    private long minSequenceNumber;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;

    public GetBucketHistorySpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetBucketHistorySpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetBucketHistorySpectraS3Request withMinSequenceNumber(long minSequenceNumber) {
        this.minSequenceNumber = minSequenceNumber;
        this.updateQueryParam("min_sequence_number", minSequenceNumber);
        return this;
    }

    public GetBucketHistorySpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetBucketHistorySpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetBucketHistorySpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetBucketHistorySpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket_history";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public long getMinSequenceNumber() {
        return this.minSequenceNumber;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }
}

