/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.DAVTimestampFeature;
import com.github.sardine.DavResource;
import com.github.sardine.util.SardineUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class BrickTimestampFeature
extends DAVTimestampFeature {
    private static final String MS_NAMESPACE_URI = "http://brickftp.com/ns";
    private static final String MS_NAMESPACE_PREFIX = "s";
    private static final String MS_NAMESPACE_LASTMODIFIED = "provided_mtime";
    public static final QName LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE = new QName("http://brickftp.com/ns", "provided_mtime", "s");

    public BrickTimestampFeature(BrickSession session) {
        super((DAVSession)session);
    }

    protected List<Element> getCustomProperties(DavResource resource, Long modified) {
        ArrayList<Element> props = new ArrayList<Element>();
        Element element = SardineUtil.createElement((QName)LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE);
        element.setTextContent(new RFC1123DateFormatter().format(modified.longValue(), TimeZone.getTimeZone("GMT")));
        props.add(element);
        return props;
    }
}

