/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class LocalTouchFeature
implements Touch {
    private final LocalSession session;

    public LocalTouchFeature(LocalSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (file.isFile()) {
            try {
                Files.createFile(this.session.toPath(file), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new LocalExceptionMappingService().map("Cannot create {0}", e, file);
            }
        }
        return new Path(file.getParent(), file.getName(), file.getType(), new LocalAttributesFinderFeature(this.session).find(file));
    }

    public Touch withWriter(Write writer) {
        return this;
    }
}

