/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils.hashing;

import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.utils.hashing.CRC32CHasher;
import com.spectralogic.ds3client.utils.hashing.CRC32Hasher;
import com.spectralogic.ds3client.utils.hashing.Hasher;
import com.spectralogic.ds3client.utils.hashing.MD5Hasher;
import com.spectralogic.ds3client.utils.hashing.SHA256Hasher;
import com.spectralogic.ds3client.utils.hashing.SHA512Hasher;
import java.io.IOException;
import java.io.InputStream;

public final class ChecksumUtils {
    private static final int READ_BUFFER_SIZE = 0xA00000;

    private ChecksumUtils() {
    }

    public static Hasher getHasher(ChecksumType.Type checksumType) {
        switch (checksumType) {
            case MD5: {
                return new MD5Hasher();
            }
            case SHA_256: {
                return new SHA256Hasher();
            }
            case SHA_512: {
                return new SHA512Hasher();
            }
            case CRC_32: {
                return new CRC32Hasher();
            }
            case CRC_32C: {
                return new CRC32CHasher();
            }
        }
        throw new RuntimeException("Unknown checksum type " + checksumType.toString());
    }

    public static String hashInputStream(Hasher digest, InputStream stream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[0xA00000];
        while ((bytesRead = stream.read(buffer)) >= 0) {
            digest.update(buffer, 0, bytesRead);
        }
        return digest.digest();
    }
}

