/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.pagination;

import com.google.common.base.Function;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.GetBucketRequest;
import com.spectralogic.ds3client.commands.GetBucketResponse;
import com.spectralogic.ds3client.models.ListBucketResult;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.networking.FailedToGetBucketException;
import com.spectralogic.ds3client.networking.TooManyRetriesException;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.collections.LazyIterable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class GetBucketKeyLoader<T>
implements LazyIterable.LazyLoader<T> {
    private static final int DEFAULT_MAX_KEYS = 1000;
    private final List<T> emptyList = Collections.emptyList();
    private final Ds3Client client;
    private final String bucket;
    private final String prefix;
    private final String delimiter;
    private final int maxKeys;
    private final int retryCount;
    private final Function<ListBucketResult, Iterable<T>> function;
    private String nextMarker;
    private boolean truncated;
    private boolean endOfInput = false;

    GetBucketKeyLoader(Ds3Client client, String bucket, String prefix, String delimiter, String nextMarker, int maxKeys, int retryCount, Function<ListBucketResult, Iterable<T>> function) {
        this.client = client;
        this.bucket = bucket;
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.nextMarker = nextMarker;
        this.maxKeys = Math.min(maxKeys, 1000);
        this.retryCount = retryCount;
        this.nextMarker = nextMarker;
        this.truncated = nextMarker != null;
        this.function = function;
    }

    private GetBucketRequest prepRequest() {
        GetBucketRequest request = new GetBucketRequest(this.bucket);
        if (this.prefix != null) {
            request.withPrefix(this.prefix);
        }
        if (this.truncated) {
            request.withMarker(this.nextMarker);
        }
        if (this.delimiter != null) {
            request.withDelimiter(this.delimiter);
        }
        request.withMaxKeys(this.maxKeys);
        return request;
    }

    @Override
    public Iterable<T> getNextValues() {
        if (this.endOfInput) {
            return this.emptyList;
        }
        for (int retryAttempt = 0; this.retryCount > retryAttempt; ++retryAttempt) {
            GetBucketResponse response;
            GetBucketRequest request = this.prepRequest();
            try {
                response = this.client.getBucket(request);
            }
            catch (FailedRequestException e) {
                throw new FailedToGetBucketException("Failed to get the list of objects due to a failed request", e);
            }
            catch (IOException e) {
                continue;
            }
            ListBucketResult result = response.getListBucketResult();
            this.truncated = result.getTruncated();
            this.nextMarker = result.getNextMarker();
            if (Guard.isStringNullOrEmpty((String)this.nextMarker) && !this.truncated) {
                this.endOfInput = true;
            }
            return (Iterable)this.function.apply((Object)result);
        }
        throw new TooManyRetriesException("Failed to get the next set of objects from the getBucketKey request after " + this.retryCount + " retries");
    }
}

