/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataIsolationLevel;
import com.spectralogic.ds3client.models.DataPersistenceRuleType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ModifyDataPersistenceRuleSpectraS3Request
extends AbstractRequest {
    private final String dataPersistenceRuleId;
    private DataIsolationLevel isolationLevel;
    private Integer minimumDaysToRetain;
    private DataPersistenceRuleType type;

    public ModifyDataPersistenceRuleSpectraS3Request(UUID dataPersistenceRuleId) {
        this.dataPersistenceRuleId = dataPersistenceRuleId.toString();
    }

    public ModifyDataPersistenceRuleSpectraS3Request(String dataPersistenceRuleId) {
        this.dataPersistenceRuleId = dataPersistenceRuleId;
    }

    public ModifyDataPersistenceRuleSpectraS3Request withIsolationLevel(DataIsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        this.updateQueryParam("isolation_level", isolationLevel);
        return this;
    }

    public ModifyDataPersistenceRuleSpectraS3Request withMinimumDaysToRetain(Integer minimumDaysToRetain) {
        this.minimumDaysToRetain = minimumDaysToRetain;
        this.updateQueryParam("minimum_days_to_retain", minimumDaysToRetain);
        return this;
    }

    public ModifyDataPersistenceRuleSpectraS3Request withType(DataPersistenceRuleType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/data_persistence_rule/" + this.dataPersistenceRuleId;
    }

    public String getDataPersistenceRuleId() {
        return this.dataPersistenceRuleId;
    }

    public DataIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public Integer getMinimumDaysToRetain() {
        return this.minimumDaysToRetain;
    }

    public DataPersistenceRuleType getType() {
        return this.type;
    }
}

