/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.TargetFailureType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetDs3TargetFailuresSpectraS3Request
extends AbstractPaginationRequest {
    private String errorMessage;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String targetId;
    private TargetFailureType type;

    public GetDs3TargetFailuresSpectraS3Request withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.updateQueryParam("error_message", errorMessage);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withTargetId(UUID targetId) {
        this.targetId = targetId.toString();
        this.updateQueryParam("target_id", targetId);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withTargetId(String targetId) {
        this.targetId = targetId;
        this.updateQueryParam("target_id", targetId);
        return this;
    }

    public GetDs3TargetFailuresSpectraS3Request withType(TargetFailureType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/ds3_target_failure";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public TargetFailureType getType() {
        return this.type;
    }
}

