/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class FormatTapeSpectraS3Request
extends AbstractRequest {
    private final String tapeId;
    private boolean force;

    public FormatTapeSpectraS3Request(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.getQueryParams().put("operation", "format");
    }

    public FormatTapeSpectraS3Request(String tapeId) {
        this.tapeId = tapeId;
        this.getQueryParams().put("operation", "format");
    }

    public FormatTapeSpectraS3Request withForce(boolean force) {
        this.force = force;
        if (this.force) {
            this.getQueryParams().put("force", null);
        } else {
            this.getQueryParams().remove("force");
        }
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape/" + this.tapeId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public boolean getForce() {
        return this.force;
    }
}

