/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.GetObjectResponse;
import com.spectralogic.ds3client.commands.interfaces.MetadataImpl;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.exceptions.ContentLengthNotMatchException;
import com.spectralogic.ds3client.networking.Metadata;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.utils.IOUtils;
import com.spectralogic.ds3client.utils.PerformanceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.WritableByteChannel;

public class GetObjectResponseParser
extends AbstractResponseParser<GetObjectResponse> {
    private final int[] expectedStatusCodes = new int[]{200, 206};
    private final WritableByteChannel destinationChannel;
    private final int bufferSize;
    private final String objName;

    public GetObjectResponseParser(WritableByteChannel destinationChannel, int bufferSize, String objName) {
        this.destinationChannel = destinationChannel;
        this.bufferSize = bufferSize;
        this.objName = objName;
    }

    @Override
    public GetObjectResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            MetadataImpl metadata = new MetadataImpl(this.getResponse().getHeaders());
            long objectSize = ResponseParserUtils.getSizeFromHeaders(this.getResponse().getHeaders());
            this.download(objectSize, this.getResponse());
            return new GetObjectResponse((Metadata)metadata, objectSize, this.getChecksum(), this.getChecksumType());
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }

    protected void download(long objectSize, WebResponse response) throws IOException {
        try (InputStream responseStream = response.getResponseStream();){
            long startTime = PerformanceUtils.getCurrentTime();
            long totalBytes = IOUtils.copy(responseStream, this.destinationChannel, this.bufferSize, this.objName, false);
            this.destinationChannel.close();
            long endTime = PerformanceUtils.getCurrentTime();
            if (objectSize != -1L && totalBytes != objectSize) {
                throw new ContentLengthNotMatchException(this.objName, objectSize, totalBytes);
            }
            PerformanceUtils.logMbps(startTime, endTime, totalBytes, this.objName, false);
        }
    }
}

