/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import com.joyent.manta.exception.MantaResourceCloseException;
import com.joyent.manta.util.ContinuingInputStream;
import com.joyent.manta.util.InputStreamContinuator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoContinuingInputStream
extends ContinuingInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(AutoContinuingInputStream.class);
    private final InputStreamContinuator continuator;

    public AutoContinuingInputStream(InputStream wrapped, InputStreamContinuator continuator) {
        super(wrapped);
        this.continuator = Objects.requireNonNull(continuator);
    }

    private void attemptRecovery(IOException originalIOException) throws IOException {
        try {
            super.continueWith(this.continuator.buildContinuation(originalIOException, this.getBytesRead()));
        }
        catch (IOException | UncheckedIOException ioe) {
            LOG.debug("Failed to automatically recover: {}", (Object)ioe.getMessage());
            if (originalIOException != ioe) {
                originalIOException.addSuppressed(ioe);
            }
            throw originalIOException;
        }
    }

    @Override
    public int read() throws IOException {
        while (true) {
            try {
                return super.read();
            }
            catch (IOException e) {
                this.attemptRecovery(e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        while (true) {
            try {
                return super.read(b);
            }
            catch (IOException e) {
                this.attemptRecovery(e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            try {
                return super.read(b, off, len);
            }
            catch (IOException e) {
                this.attemptRecovery(e);
                continue;
            }
            break;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        while (true) {
            try {
                return super.skip(n);
            }
            catch (IOException e) {
                this.attemptRecovery(e);
                continue;
            }
            break;
        }
    }

    @Override
    public int available() throws IOException {
        while (true) {
            try {
                return this.getWrapped().available();
            }
            catch (IOException e) {
                this.attemptRecovery(e);
                continue;
            }
            break;
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark/reset not supported");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.continuator != null) {
                this.continuator.close();
            }
        }
        catch (IOException e) {
            String msg = "Error closing continuator";
            throw new MantaResourceCloseException(msg, e);
        }
        InputStream wrapped = this.getWrapped();
        try {
            if (wrapped != null) {
                wrapped.close();
            }
        }
        catch (IOException e) {
            String msg = "Error closing wrapped InputStream";
            throw new MantaResourceCloseException(msg, e);
        }
    }
}

