/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.jobs;

import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.client.jobs.MantaJob;
import com.joyent.manta.client.jobs.MantaJobError;
import com.joyent.manta.client.jobs.MantaJobPhase;
import com.joyent.manta.exception.MantaClientException;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import com.joyent.manta.exception.MantaJobException;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaJobBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MantaJobBuilder.class);
    private final MantaClient client;

    public MantaJobBuilder(MantaClient client) {
        this.client = client;
    }

    public Create newJob(String name) {
        return new Create(this, name);
    }

    public Run lookupJob(MantaJob job) {
        Validate.notNull((Object)job, (String)"Job must not be null", (Object[])new Object[0]);
        return this.lookupJob(job.getId());
    }

    public Run lookupJob(UUID jobId) {
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        return new Run(this, jobId);
    }

    public Create cloneJob(UUID jobId) throws IOException {
        MantaJob job = this.client.getJob(jobId);
        return this.cloneJob(job);
    }

    public Create cloneJob(MantaJob job) throws IOException {
        Create newJob = new Create(this, job.getName());
        newJob.addPhases(job.getPhases());
        try (Stream<String> inputs = this.client.getJobInputs(job.getId());){
            newJob.addInputs(inputs);
            Create create = newJob;
            return create;
        }
    }

    public static class Done {
        private final UUID id;
        private final MantaJobBuilder parent;

        Done(UUID id, MantaJobBuilder parent) {
            this.id = id;
            this.parent = parent;
        }

        public Stream<MantaObjectInputStream> outputAsStreams() throws IOException {
            return this.parent.client.getJobOutputsAsStreams(this.id);
        }

        public Stream<String> outputs() throws IOException {
            return this.parent.client.getJobOutputsAsStrings(this.id);
        }

        public Stream<MantaJobError> errors() throws IOException {
            return this.parent.client.getJobErrors(this.id);
        }

        public MantaJob getJob() throws IOException {
            return this.parent.client.getJob(this.id);
        }

        public boolean failed() throws IOException {
            Number errors = this.getJob().getStats().get("errors");
            if (errors != null) {
                return errors.intValue() > 0;
            }
            throw new MantaClientException("Unable to get error stats");
        }

        public boolean successful() throws IOException {
            return !this.failed();
        }

        public Done validateJobsSucceeded() throws IOException {
            if (this.successful()) {
                return this;
            }
            throw new MantaJobException(this.id, this.errors().collect(Collectors.toList()));
        }
    }

    public static class Run {
        private final UUID id;
        private final MantaJobBuilder parent;
        private static final Duration DEFAULT_TIME_BETWEEN_POLLS = Duration.of(3L, ChronoUnit.SECONDS);
        private static final int DEFAULT_MAX_POLLS = 100;

        Run(MantaJobBuilder parent, UUID id) {
            this.parent = parent;
            this.id = id;
        }

        public void cancel() throws IOException {
            this.parent.client.cancelJob(this.id);
        }

        public boolean isDone() throws IOException {
            return this.getJob().getState().equals("done");
        }

        public MantaJob getJob() throws IOException {
            return this.parent.client.getJob(this.id);
        }

        public UUID getId() {
            return this.id;
        }

        public Done waitUntilDone() throws IOException {
            return this.waitUntilDone(DEFAULT_TIME_BETWEEN_POLLS, 100);
        }

        public Done waitUntilDone(Duration timeBetweenPolls, int maxPolls) throws IOException {
            for (int i = 0; i < maxPolls; ++i) {
                if (this.isDone()) {
                    return new Done(this.id, this.parent);
                }
                try {
                    LOG.debug("Waiting for {} ms before checking again. Check #{}", (Object)timeBetweenPolls.toMillis(), (Object)i);
                    Thread.sleep(timeBetweenPolls.toMillis());
                    continue;
                }
                catch (InterruptedException e) {
                    throw new MantaJobException(this.id, "Can't wait any longer for job to finish", e);
                }
            }
            throw new MantaJobException(this.id, "Job didn't complete in the expected amount of time");
        }

        public Done done() {
            return new Done(this.id, this.parent);
        }
    }

    public static class Create {
        private final String name;
        private final MantaJobBuilder parent;
        private final List<MantaJobPhase> phases = new CopyOnWriteArrayList<MantaJobPhase>();
        private final List<String> inputs = new CopyOnWriteArrayList<String>();

        private Create(MantaJobBuilder parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Create addPhase(MantaJobPhase phase) {
            Validate.notNull((Object)phase, (String)"Phase must not be null", (Object[])new Object[0]);
            this.phases.add(phase);
            return this;
        }

        public Create addPhases(Iterable<MantaJobPhase> additionalPhases) {
            Validate.notNull(this.phases, (String)"Phases must not be null", (Object[])new Object[0]);
            for (MantaJobPhase phase : additionalPhases) {
                this.phases.add(phase);
            }
            return this;
        }

        public Create addPhases(Stream<MantaJobPhase> additionalPhases) {
            Validate.notNull(this.phases, (String)"Phases must not be null", (Object[])new Object[0]);
            additionalPhases.forEach(this.phases::add);
            return this;
        }

        public Create addPhases(MantaJobPhase ... additionalPhases) {
            Validate.notNull(this.phases, (String)"Phases must not be null", (Object[])new Object[0]);
            Collections.addAll(this.phases, additionalPhases);
            return this;
        }

        public Create addInput(String input) {
            this.inputs.add(input);
            return this;
        }

        public Create addInputs(Iterable<String> additionalInputs) {
            for (String input : additionalInputs) {
                this.inputs.add(input);
            }
            return this;
        }

        public Create addInputs(Stream<String> additionalInputs) {
            additionalInputs.forEach(this.inputs::add);
            return this;
        }

        public Create addInputs(String ... additionalInputs) {
            Collections.addAll(this.inputs, additionalInputs);
            return this;
        }

        public Create validateInputs() {
            StringBuilder builder = new StringBuilder();
            HashMap<String, Exception> generalExceptions = new HashMap<String, Exception>();
            HashMap<String, MantaClientHttpResponseException> mantaExceptions = new HashMap<String, MantaClientHttpResponseException>();
            for (String input : this.inputs) {
                try {
                    MantaObjectResponse obj = this.parent.client.head(input);
                    if (!obj.isDirectory()) continue;
                    throw new MantaException("Object is not a file, but is a directory");
                }
                catch (MantaClientHttpResponseException e) {
                    mantaExceptions.put(input, e);
                }
                catch (Exception e) {
                    generalExceptions.put(input, e);
                }
            }
            if (!generalExceptions.isEmpty() || !mantaExceptions.isEmpty()) {
                builder.append("Error with inputs:");
                generalExceptions.entrySet().forEach(entry -> builder.append(System.lineSeparator()).append("[").append((String)entry.getKey()).append("] ").append(((Exception)entry.getValue()).getMessage()));
                mantaExceptions.entrySet().forEach(entry -> builder.append(System.lineSeparator()).append("[").append((String)entry.getKey()).append("] ").append("(").append((Object)((MantaClientHttpResponseException)entry.getValue()).getServerCode()).append(") ").append(((MantaClientHttpResponseException)entry.getValue()).getMessage()));
                throw new MantaJobException(builder.toString());
            }
            return this;
        }

        public Run run() throws IOException {
            MantaJob job = new MantaJob(this.name, this.phases);
            UUID id = this.parent.client.createJob(job);
            this.parent.client.addJobInputs(id, this.inputs.iterator());
            if (!this.parent.client.endJobInput(id)) {
                throw new MantaJobException(id, "Unable to end inputs to job");
            }
            return new Run(this.parent, id);
        }
    }
}

