/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class StringIteratorHttpContent
implements HttpEntity {
    private final Iterator<String> iterator;
    private final Stream<String> stream;
    private final ContentType contentType;
    private AtomicLong length = new AtomicLong(-1L);

    public StringIteratorHttpContent(Iterator<String> iterator, ContentType contentType) {
        this.iterator = iterator;
        this.stream = null;
        this.contentType = contentType;
    }

    public StringIteratorHttpContent(Stream<String> stream, ContentType contentType) {
        this.stream = stream;
        this.iterator = null;
        this.contentType = contentType;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return this.length.get();
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", this.contentType.toString());
    }

    public void writeTo(OutputStream out) throws IOException {
        try {
            if (this.iterator != null) {
                this.writeIterator(out);
            } else if (this.stream != null) {
                this.writeStream(out);
            }
        }
        finally {
            out.close();
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getContent isn't supported");
    }

    @Deprecated
    public void consumeContent() throws IOException {
        throw new UnsupportedOperationException("getContent isn't supported");
    }

    public Header getContentEncoding() {
        return null;
    }

    public boolean isStreaming() {
        return true;
    }

    protected void writeIterator(OutputStream out) throws IOException {
        Validate.notNull(this.iterator, (String)"Iterator must not be null", (Object[])new Object[0]);
        this.length.set(0L);
        while (this.iterator.hasNext()) {
            String next = this.iterator.next();
            if (next == null) continue;
            String formatted = String.format("%s%s", next, "\n");
            byte[] bytes = formatted.getBytes(StandardCharsets.UTF_8);
            this.length.addAndGet(bytes.length);
            out.write(bytes);
        }
    }

    protected void writeStream(OutputStream out) throws IOException {
        Validate.notNull(this.stream, (String)"Stream must not be null", (Object[])new Object[0]);
        this.length.set(0L);
        try {
            this.stream.forEach(item -> {
                if (item != null) {
                    try {
                        String formatted = String.format("%s\n", item);
                        byte[] bytes = formatted.getBytes(StandardCharsets.UTF_8);
                        this.length.addAndGet(bytes.length);
                        out.write(bytes);
                    }
                    catch (IOException e) {
                        throw new StreamIOException(e);
                    }
                }
            });
        }
        catch (StreamIOException e) {
            throw e.getIOCause();
        }
    }

    protected static class StreamIOException
    extends RuntimeException {
        private static final long serialVersionUID = 1317022643615834337L;

        public StreamIOException(Throwable cause) {
            super(cause);
        }

        IOException getIOCause() {
            return (IOException)this.getCause();
        }
    }
}

