/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.joyent.manta.client.MantaObjectMapper;
import com.joyent.manta.domain.ObjectType;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.exception.MantaResourceCloseException;
import com.joyent.manta.exception.MantaUnexpectedObjectTypeException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaDirectoryListingIterator
implements Iterator<Map<String, Object>>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MantaDirectoryListingIterator.class);
    static final int MAX_RESULTS = 1024;
    private final int pagingSize;
    private final String path;
    private final HttpHelper httpHelper;
    private final AtomicLong lines = new AtomicLong(0L);
    private final AtomicReference<String> nextLine = new AtomicReference();
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final ObjectMapper mapper = MantaObjectMapper.INSTANCE;
    private volatile String lastMarker;
    private volatile BufferedReader br;
    private volatile CloseableHttpResponse currentResponse;

    @Deprecated
    public MantaDirectoryListingIterator(String url, String path, HttpHelper httpHelper, int pagingSize) {
        this(path, httpHelper, pagingSize);
    }

    public MantaDirectoryListingIterator(String path, HttpHelper httpHelper, int pagingSize) {
        Validate.notBlank((CharSequence)path, (String)"Path must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)httpHelper, (String)"HTTP help must not be null", (Object[])new Object[0]);
        this.path = path;
        this.httpHelper = httpHelper;
        if (pagingSize < 2) {
            throw new IllegalArgumentException("Paging size must be greater than 1 and less than or equal to 1024");
        }
        this.pagingSize = pagingSize;
    }

    private synchronized void selectReader() throws IOException {
        String results;
        HttpGet request;
        String query;
        if (this.lastMarker == null) {
            query = String.format("?limit=%d", this.pagingSize);
            request = this.httpHelper.getRequestFactory().get(MantaUtils.formatPath(this.path) + query);
            try {
                if (this.currentResponse != null) {
                    this.currentResponse.close();
                }
            }
            catch (IOException e) {
                MantaIOException mio = new MantaIOException(e);
                HttpHelper.annotateContextedException(mio, (HttpRequest)request, (HttpResponse)this.currentResponse);
                throw mio;
            }
            this.currentResponse = this.httpHelper.executeRequest((HttpUriRequest)request, null, new Object[0]);
            HttpEntity entity = this.currentResponse.getEntity();
            String contentType = entity.getContentType() != null ? entity.getContentType().getValue() : null;
            if (!"application/x-json-stream; type=directory".equals(contentType)) {
                String msg = "A file was specified as the directory list path. Only the contents of directories can be listed.";
                MantaUnexpectedObjectTypeException e = new MantaUnexpectedObjectTypeException(msg, ObjectType.DIRECTORY, ObjectType.FILE);
                e.setContextValue("path", this.path);
                try {
                    MantaHttpHeaders headers = new MantaHttpHeaders(this.currentResponse.getAllHeaders());
                    e.setResponseHeaders(headers);
                }
                catch (RuntimeException re) {
                    LOG.warn("Unable to convert response headers to MantaHttpHeaders", (Throwable)((Object)e));
                }
                throw e;
            }
            InputStream contentStream = entity.getContent();
            Objects.requireNonNull(contentStream, "A directory listing without content is not valid. Content is null.");
            InputStreamReader streamReader = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8.name());
            this.br = new BufferedReader(streamReader);
        } else {
            query = String.format("?limit=%d&marker=%s", this.pagingSize, URLEncoder.encode(this.lastMarker, "UTF-8"));
            request = this.httpHelper.getRequestFactory().get(MantaUtils.formatPath(this.path) + query);
            this.closeResources();
            this.currentResponse = this.httpHelper.executeRequest((HttpUriRequest)request, null, new Object[0]);
            HttpEntity entity = this.currentResponse.getEntity();
            InputStreamReader streamReader = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8.name());
            this.br = new BufferedReader(streamReader);
            this.br.readLine();
        }
        Header resultsHeader = this.currentResponse.getFirstHeader("result-set-size");
        if (resultsHeader != null && (results = resultsHeader.getValue()).equals("0")) {
            this.finished.set(true);
            return;
        }
        this.nextLine.set(this.br.readLine());
        this.lines.incrementAndGet();
        this.finished.set(this.nextLine.get() == null);
    }

    @Override
    public boolean hasNext() {
        if (!this.finished.get() && this.nextLine.get() == null) {
            try {
                this.selectReader();
                return !this.finished.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return !this.finished.get();
    }

    @Override
    public synchronized Map<String, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            String line = this.nextLine.getAndSet(this.br.readLine());
            this.lines.incrementAndGet();
            if (line == null) {
                this.selectReader();
                if (this.finished.get()) {
                    throw new NoSuchElementException();
                }
                line = this.nextLine.getAndSet(this.br.readLine());
            }
            Map lookup = (Map)this.mapper.readValue(line, (TypeReference)new TypeReference<Map<String, Object>>(){});
            String name = Objects.toString(lookup.get("name"));
            Validate.notNull((Object)name, (String)"Name must not be null in JSON input", (Object[])new Object[0]);
            lookup.put("path", this.path);
            this.lastMarker = name;
            return lookup;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        this.finished.set(true);
        this.closeResources();
    }

    private void closeResources() {
        MantaResourceCloseException mio;
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (IOException e) {
            mio = new MantaResourceCloseException(e);
            HttpHelper.annotateContextedException(mio, null, (HttpResponse)this.currentResponse);
            LOG.error("Unable to close BufferedReader", (Throwable)mio);
        }
        try {
            if (this.currentResponse != null) {
                this.currentResponse.close();
            }
        }
        catch (IOException e) {
            mio = new MantaResourceCloseException(e);
            HttpHelper.annotateContextedException(mio, null, (HttpResponse)this.currentResponse);
            LOG.error("Unable to close HTTP response object", (Throwable)mio);
        }
    }

    public long getLines() {
        return this.lines.get();
    }
}

