/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature;

import com.joyent.http.signature.Signer;
import com.joyent.http.signature.ThreadLocalClearException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class ThreadLocalSigner
extends ThreadLocal<Signer> {
    private static Set<Thread> threadsReferencing = new CopyOnWriteArraySet<Thread>();
    private Signer.Builder builder;

    @Deprecated
    public ThreadLocalSigner() {
        this(true);
    }

    @Deprecated
    public ThreadLocalSigner(boolean useNativeCodeToSign) {
        this.builder = new Signer.Builder("RSA").providerCode(useNativeCodeToSign ? "native.jnagmp" : "stdlib");
    }

    public ThreadLocalSigner(Signer.Builder builder) {
        this.builder = builder;
    }

    @Override
    protected Signer initialValue() {
        threadsReferencing.add(Thread.currentThread());
        return this.builder.build();
    }

    @Override
    public void remove() {
        super.remove();
        threadsReferencing.remove(Thread.currentThread());
    }

    @Override
    public void set(Signer value) {
        super.set(value);
        if (value == null) {
            threadsReferencing.remove(Thread.currentThread());
        }
    }

    public void clearAll() {
        try {
            Method getMap = ThreadLocal.class.getDeclaredMethod("getMap", Thread.class);
            getMap.setAccessible(true);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Method remove = threadLocalMapClass.getDeclaredMethod("remove", ThreadLocal.class);
            remove.setAccessible(true);
            for (Thread t : threadsReferencing) {
                Object map = getMap.invoke((Object)this, t);
                if (map == null) continue;
                remove.invoke(map, this);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new ThreadLocalClearException(e);
        }
    }
}

