/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalAlertCallback;
import ch.cyberduck.cli.TerminalAppender;
import ch.cyberduck.cli.TerminalCertificateStore;
import ch.cyberduck.cli.TerminalHostKeyVerifier;
import ch.cyberduck.cli.TerminalLoginCallback;
import ch.cyberduck.cli.TerminalNotification;
import ch.cyberduck.cli.TerminalOptionsBuilder;
import ch.cyberduck.cli.TerminalPasswordCallback;
import ch.cyberduck.cli.TerminalTransferErrorCallback;
import ch.cyberduck.cli.TerminalTransferPrompt;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.random.FastSecureRandomProvider;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class TerminalPreferences
extends Preferences {
    private static final Logger log = Logger.getLogger(TerminalPreferences.class);
    private final Preferences proxy;

    public TerminalPreferences(Preferences persistence) {
        this.proxy = persistence;
    }

    @Override
    protected void setFactories() {
        super.setFactories();
        this.setDefault("factory.certificatestore.class", TerminalCertificateStore.class.getName());
        this.setDefault("factory.logincallback.class", TerminalLoginCallback.class.getName());
        this.setDefault("factory.passwordcallback.class", TerminalPasswordCallback.class.getName());
        this.setDefault("factory.alertcallback.class", TerminalAlertCallback.class.getName());
        this.setDefault("factory.hostkeycallback.class", TerminalHostKeyVerifier.class.getName());
        this.setDefault("factory.transfererrorcallback.class", TerminalTransferErrorCallback.class.getName());
        this.setDefault("factory.notification.class", TerminalNotification.class.getName());
        for (Transfer.Type t : Transfer.Type.values()) {
            this.setDefault(String.format("factory.transferpromptcallback.%s.class", t.name()), TerminalTransferPrompt.class.getName());
        }
        this.setDefault("factory.vault.class", CryptoVault.class.getName());
        this.setDefault("factory.securerandom.class", FastSecureRandomProvider.class.getName());
    }

    @Override
    protected void configureLogging(String level) {
        super.configureLogging(level);
        Logger root = Logger.getRootLogger();
        TerminalAppender appender = new TerminalAppender();
        appender.setLayout((Layout)new PatternLayout("[%t] %-5p %c - %m%n"));
        root.addAppender((Appender)appender);
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.setDefault("logging", "fatal");
        this.setDefault("website.home", "http://duck.sh/");
        this.setDefault("website.help", "http://help.duck.sh/");
        System.setProperty("jna.library.path", this.getProperty("java.library.path"));
        this.setDefault("local.normalize.prefix", String.valueOf(true));
        this.setDefault("connection.login.name", System.getProperty("user.name"));
        this.setDefault("queue.download.skip.enable", "false");
        this.setDefault("queue.upload.skip.enable", "false");
        this.setDefault("queue.copy.action", TransferAction.comparison.name());
        this.setDefault("queue.copy.reload.action", TransferAction.comparison.name());
        this.setDefault("keychain.secure", String.valueOf(false));
    }

    public TerminalPreferences withDefaults(CommandLine input) {
        if (input.hasOption(TerminalOptionsBuilder.Params.chmod.name())) {
            Permission permission = new Permission(input.getOptionValue(TerminalOptionsBuilder.Params.chmod.name()));
            this.setDefault("queue.upload.permissions.change", String.valueOf(true));
            this.setDefault("queue.upload.permissions.default", String.valueOf(true));
            this.setDefault("queue.upload.permissions.file.default", permission.getMode());
        }
        if (input.hasOption(TerminalOptionsBuilder.Params.debug.name())) {
            this.setLogging("debug");
        }
        return this;
    }

    @Override
    public void setDefault(String property, String value) {
        this.proxy.setDefault(property, value);
    }

    @Override
    public String getProperty(String property) {
        String env = System.getenv(property);
        if (null == env) {
            String system = System.getProperty(property);
            if (null == system) {
                return this.proxy.getProperty(property);
            }
            return system;
        }
        return env;
    }

    @Override
    public void setProperty(String property, String v) {
        this.proxy.setProperty(property, v);
    }

    @Override
    public void deleteProperty(String property) {
        this.proxy.deleteProperty(property);
    }

    @Override
    public String getDefault(String property) {
        return this.proxy.getDefault(property);
    }

    @Override
    public void save() {
        this.proxy.save();
    }

    @Override
    public void load() {
        this.proxy.load();
    }

    @Override
    public List<String> applicationLocales() {
        return this.proxy.applicationLocales();
    }

    @Override
    public List<String> systemLocales() {
        return this.proxy.systemLocales();
    }
}

