/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.worker.Worker;
import java.util.Objects;

public class LoadVaultWorker
extends Worker<Vault> {
    private final VaultLookupListener listener;
    private final Path directory;

    public LoadVaultWorker(VaultLookupListener listener, Path directory) {
        this.listener = listener;
        this.directory = directory;
    }

    @Override
    public Vault run(Session<?> session) throws BackgroundException {
        return this.listener.load(session, this.directory, DefaultVaultRegistry.DEFAULT_MASTERKEY_FILE_NAME, DefaultVaultRegistry.DEFAULT_PEPPER);
    }

    @Override
    public String getActivity() {
        return LocaleFactory.localizedString("Unlock Vault", "Cryptomator");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadVaultWorker that = (LoadVaultWorker)o;
        return Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        return Objects.hash(this.directory);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LoadVaultWorker{");
        sb.append("directory=").append(this.directory);
        sb.append('}');
        return sb.toString();
    }
}

