/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.io.DelegateStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.local.IconService;
import ch.cyberduck.core.local.IconServiceFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class IconUpdateSreamListener
extends DelegateStreamListener {
    private final IconService icon = IconServiceFactory.get();
    private final TransferStatus overall;
    private final TransferStatus segment;
    private final Local file;
    private int step = 0;

    public IconUpdateSreamListener(StreamListener delegate, TransferStatus overall, TransferStatus segment, Local file) {
        super(delegate);
        this.overall = overall;
        this.segment = segment;
        this.file = file;
    }

    @Override
    public void recv(long bytes) {
        BigDecimal fraction = new BigDecimal(this.segment.getOffset()).divide(new BigDecimal(this.overall.getLength()), 1, RoundingMode.DOWN);
        if (fraction.multiply(BigDecimal.TEN).intValue() > this.step) {
            this.icon.set(this.file, this.segment);
            ++this.step;
        }
        super.recv(bytes);
    }
}

