/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.exception.SSLNegotiateException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.threading.FailureDiagnostics;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.log4j.Logger;

public final class DefaultFailureDiagnostics
implements FailureDiagnostics<BackgroundException> {
    private static final Logger log = Logger.getLogger(DefaultFailureDiagnostics.class);

    @Override
    public FailureDiagnostics.Type determine(BackgroundException failure) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Determine cause for failure %s", failure));
        }
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (failure instanceof UnsupportedException) {
                return FailureDiagnostics.Type.unsupported;
            }
            if (failure instanceof LoginFailureException) {
                return FailureDiagnostics.Type.login;
            }
            if (cause instanceof ResolveFailedException) {
                return FailureDiagnostics.Type.network;
            }
            if (failure instanceof ConnectionCanceledException) {
                return FailureDiagnostics.Type.cancel;
            }
            if (cause instanceof ConnectionTimeoutException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof ConnectionRefusedException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof SSLNegotiateException) {
                return FailureDiagnostics.Type.application;
            }
            if (cause instanceof SSLHandshakeException) {
                return FailureDiagnostics.Type.application;
            }
            if (cause instanceof SSLException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof NoHttpResponseException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof ConnectTimeoutException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof SocketException || cause instanceof IOResumeException || cause instanceof TimeoutException || cause instanceof SocketTimeoutException || cause instanceof UnknownHostException) {
                return FailureDiagnostics.Type.network;
            }
            if (!(cause instanceof QuotaException)) continue;
            return FailureDiagnostics.Type.quota;
        }
        return FailureDiagnostics.Type.application;
    }
}

