/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.threading.ActionOperationBatcher;
import ch.cyberduck.core.threading.DisabledActionOperationBatcher;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class ActionOperationBatcherFactory
extends Factory<ActionOperationBatcher> {
    private static final Logger log = Logger.getLogger(ActionOperationBatcherFactory.class);

    public ActionOperationBatcherFactory() {
        super("factory.autorelease.class");
    }

    public ActionOperationBatcher create(Integer batchsize) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{batchsize.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", batchsize.getClass()));
                return (ActionOperationBatcher)this.clazz.newInstance();
            }
            return (ActionOperationBatcher)constructor.newInstance(batchsize);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledActionOperationBatcher();
        }
    }

    public static ActionOperationBatcher get() {
        return ActionOperationBatcherFactory.get(1);
    }

    public static ActionOperationBatcher get(Integer batchsize) {
        return new ActionOperationBatcherFactory().create(batchsize);
    }
}

