/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class HttpProxyAwareSocket
extends Socket {
    private final Proxy proxy;

    public HttpProxyAwareSocket(Proxy proxy) {
        super(proxy.type() == Proxy.Type.HTTP ? Proxy.NO_PROXY : proxy);
        this.proxy = proxy;
    }

    public HttpProxyAwareSocket(SocketImpl impl, Proxy proxy) throws SocketException {
        super(impl);
        this.proxy = proxy;
    }

    public HttpProxyAwareSocket(String host, int port, Proxy proxy) throws IOException {
        super(host, port);
        this.proxy = proxy;
    }

    public HttpProxyAwareSocket(InetAddress address, int port, Proxy proxy) throws IOException {
        super(address, port);
        this.proxy = proxy;
    }

    public HttpProxyAwareSocket(String host, int port, InetAddress localAddr, int localPort, Proxy proxy) throws IOException {
        super(host, port, localAddr, localPort);
        this.proxy = proxy;
    }

    public HttpProxyAwareSocket(InetAddress address, int port, InetAddress localAddr, int localPort, Proxy proxy) throws IOException {
        super(address, port, localAddr, localPort);
        this.proxy = proxy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.proxy.type() == Proxy.Type.HTTP) {
            super.connect(this.proxy.address(), timeout);
            InetSocketAddress address = (InetSocketAddress)endpoint;
            OutputStream out = this.getOutputStream();
            IOUtils.write((String)String.format("CONNECT %s:%d HTTP/1.0\n\n", address.getHostName(), address.getPort()), (OutputStream)out, (Charset)Charset.defaultCharset());
            InputStream in = this.getInputStream();
            String response = new LineNumberReader(new InputStreamReader(in)).readLine();
            if (null == response) {
                throw new SocketException(String.format("Empty response from HTTP proxy %s", ((InetSocketAddress)this.proxy.address()).getHostName()));
            }
            if (!response.contains("200")) throw new SocketException(String.format("Invalid response %s from HTTP proxy %s", response, ((InetSocketAddress)this.proxy.address()).getHostName()));
            in.skip(in.available());
            return;
        } else {
            super.connect(endpoint, timeout);
        }
    }
}

