/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.local.TemporaryFileService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public abstract class AbstractTemporaryFileService
implements TemporaryFileService {
    private static final Logger log = Logger.getLogger(AbstractTemporaryFileService.class);
    private static final Set<Local> files = new LinkedHashSet<Local>();

    protected Local delete(Local file) {
        files.add(file);
        return file;
    }

    protected String shorten(String path, int limit) {
        if (path.length() > limit) {
            return DigestUtils.md5Hex((String)path);
        }
        return path;
    }

    @Override
    public void shutdown() {
        ArrayList<Local> list = new ArrayList<Local>(files);
        Collections.reverse(list);
        for (Local f : list) {
            try {
                f.delete();
            }
            catch (AccessDeniedException | NotfoundException e) {
                log.warn((Object)String.format("Failure deleting file %s in shutdown hook. %s", f, e.getMessage()));
            }
        }
    }
}

