/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.nulabinc.zxcvbn.Zxcvbn;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class PasswordStrengthValidator {
    private final Zxcvbn zxcvbn = new Zxcvbn();

    public Strength getScore(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return Strength.veryweak;
        }
        int score = this.zxcvbn.measure((CharSequence)password, Collections.singletonList(PreferencesFactory.get().getProperty("application.name"))).getScore();
        switch (score) {
            case 0: {
                return Strength.veryweak;
            }
            case 1: {
                return Strength.weak;
            }
            case 2: {
                return Strength.fair;
            }
            case 3: {
                return Strength.strong;
            }
        }
        return Strength.verystrong;
    }

    public static enum Strength {
        veryweak{

            @Override
            public String getDescription() {
                return LocaleFactory.localizedString("Very weak", "Cryptomator");
            }
        }
        ,
        weak{

            @Override
            public String getDescription() {
                return LocaleFactory.localizedString("Weak", "Cryptomator");
            }
        }
        ,
        fair{

            @Override
            public String getDescription() {
                return LocaleFactory.localizedString("Fair", "Cryptomator");
            }
        }
        ,
        strong{

            @Override
            public String getDescription() {
                return LocaleFactory.localizedString("Strong", "Cryptomator");
            }
        }
        ,
        verystrong{

            @Override
            public String getDescription() {
                return LocaleFactory.localizedString("Very strong", "Cryptomator");
            }
        };


        public int getScore() {
            return this.ordinal();
        }

        public abstract String getDescription();
    }
}

