/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.api;

import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.ApiResponse;
import ch.cyberduck.core.storegate.io.swagger.client.Configuration;
import ch.cyberduck.core.storegate.io.swagger.client.Pair;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileLock;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileLockRequest;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class FileLocksApi {
    private ApiClient apiClient;

    public FileLocksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FileLocksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FileLock fileLocksCreateLock(String fileId, FileLockRequest request) throws ApiException {
        return this.fileLocksCreateLockWithHttpInfo(fileId, request).getData();
    }

    public ApiResponse<FileLock> fileLocksCreateLockWithHttpInfo(String fileId, FileLockRequest request) throws ApiException {
        FileLockRequest localVarPostBody = request;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling fileLocksCreateLock");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling fileLocksCreateLock");
        }
        String localVarPath = "/v4/filelocks/{fileId}".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileLock> localVarReturnType = new GenericType<FileLock>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void fileLocksDeleteLock(String fileId, String lockId) throws ApiException {
        this.fileLocksDeleteLockWithHttpInfo(fileId, lockId);
    }

    public ApiResponse<Void> fileLocksDeleteLockWithHttpInfo(String fileId, String lockId) throws ApiException {
        Object localVarPostBody = null;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling fileLocksDeleteLock");
        }
        if (lockId == null) {
            throw new ApiException(400, "Missing the required parameter 'lockId' when calling fileLocksDeleteLock");
        }
        String localVarPath = "/v4/filelocks/{fileId}/{lockId}".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString())).replaceAll("\\{lockId\\}", this.apiClient.escapeString(lockId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public FileLock fileLocksFindLock(String fileId) throws ApiException {
        return this.fileLocksFindLockWithHttpInfo(fileId).getData();
    }

    public ApiResponse<FileLock> fileLocksFindLockWithHttpInfo(String fileId) throws ApiException {
        Object localVarPostBody = null;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling fileLocksFindLock");
        }
        String localVarPath = "/v4/filelocks/{fileId}".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileLock> localVarReturnType = new GenericType<FileLock>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileLock fileLocksUpdateLock(String fileId, String lockId, FileLockRequest request) throws ApiException {
        return this.fileLocksUpdateLockWithHttpInfo(fileId, lockId, request).getData();
    }

    public ApiResponse<FileLock> fileLocksUpdateLockWithHttpInfo(String fileId, String lockId, FileLockRequest request) throws ApiException {
        FileLockRequest localVarPostBody = request;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling fileLocksUpdateLock");
        }
        if (lockId == null) {
            throw new ApiException(400, "Missing the required parameter 'lockId' when calling fileLocksUpdateLock");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling fileLocksUpdateLock");
        }
        String localVarPath = "/v4/filelocks/{fileId}/{lockId}".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString())).replaceAll("\\{lockId\\}", this.apiClient.escapeString(lockId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileLock> localVarReturnType = new GenericType<FileLock>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

