/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import org.apache.commons.lang3.StringUtils;

public class StoregateIdProvider
implements IdProvider {
    private final StoregateSession session;

    public StoregateIdProvider(StoregateSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
                return file.attributes().getFileId();
            }
            String id = new FilesApi((ApiClient)this.session.getClient()).filesGet_1(URIEncoder.encode((String)this.getPrefixedPath(file))).getId();
            file.attributes().setFileId(id);
            return id;
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public StoregateIdProvider withCache(Cache<Path> cache) {
        return this;
    }

    protected String getPrefixedPath(Path file) {
        PathContainerService service = new PathContainerService();
        String root = service.getContainer(file).getAbsolute();
        for (RootFolder r : this.session.roots()) {
            if (!root.endsWith(r.getName())) continue;
            if (service.isContainer(file)) {
                return r.getPath();
            }
            return String.format("%s/%s", r.getPath(), PathRelativizer.relativize((String)root, (String)file.getAbsolute()));
        }
        return file.getAbsolute();
    }
}

