/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import java.io.IOException;

public class MantaTouchFeature
implements Touch {
    private final MantaSession session;

    public MantaTouchFeature(MantaSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            if (!((MantaClient)this.session.getClient()).existsAndIsAccessible(file.getParent().getAbsolute())) {
                ((MantaClient)this.session.getClient()).putDirectory(file.getParent().getAbsolute());
            }
            ((MantaClient)this.session.getClient()).put(file.getAbsolute(), new byte[0]);
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map("Cannot create {0}", e, file);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Cannot create {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", (Throwable)e, file);
        }
        return file;
    }

    public boolean isSupported(Path workdir, String filename) {
        return this.session.isUserWritable(workdir);
    }

    public Touch withWriter(Write writer) {
        return this;
    }
}

