/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum FedHandshakeAction {
    INVITED,
    ACCEPTED_INVITE,
    REJECTED_INVITE,
    CANCELED_INVITE,
    REMOVED_TEAM,
    INVITE_EXPIRED,
    OTHER;


    static class Serializer
    extends UnionSerializer<FedHandshakeAction> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FedHandshakeAction value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INVITED: {
                    g.writeString("invited");
                    break;
                }
                case ACCEPTED_INVITE: {
                    g.writeString("accepted_invite");
                    break;
                }
                case REJECTED_INVITE: {
                    g.writeString("rejected_invite");
                    break;
                }
                case CANCELED_INVITE: {
                    g.writeString("canceled_invite");
                    break;
                }
                case REMOVED_TEAM: {
                    g.writeString("removed_team");
                    break;
                }
                case INVITE_EXPIRED: {
                    g.writeString("invite_expired");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public FedHandshakeAction deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            FedHandshakeAction value = "invited".equals(tag) ? INVITED : ("accepted_invite".equals(tag) ? ACCEPTED_INVITE : ("rejected_invite".equals(tag) ? REJECTED_INVITE : ("canceled_invite".equals(tag) ? CANCELED_INVITE : ("removed_team".equals(tag) ? REMOVED_TEAM : ("invite_expired".equals(tag) ? INVITE_EXPIRED : OTHER)))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

