/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.files.FileMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ListRevisionsResult {
    protected final boolean isDeleted;
    protected final Date serverDeleted;
    protected final List<FileMetadata> entries;

    public ListRevisionsResult(boolean isDeleted, List<FileMetadata> entries, Date serverDeleted) {
        this.isDeleted = isDeleted;
        this.serverDeleted = LangUtil.truncateMillis(serverDeleted);
        if (entries == null) {
            throw new IllegalArgumentException("Required value for 'entries' is null");
        }
        for (FileMetadata x : entries) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'entries' is null");
        }
        this.entries = entries;
    }

    public ListRevisionsResult(boolean isDeleted, List<FileMetadata> entries) {
        this(isDeleted, entries, null);
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public List<FileMetadata> getEntries() {
        return this.entries;
    }

    public Date getServerDeleted() {
        return this.serverDeleted;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.isDeleted, this.serverDeleted, this.entries});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListRevisionsResult other = (ListRevisionsResult)obj;
            return this.isDeleted == other.isDeleted && (this.entries == other.entries || this.entries.equals(other.entries)) && (this.serverDeleted == other.serverDeleted || this.serverDeleted != null && this.serverDeleted.equals(other.serverDeleted));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListRevisionsResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListRevisionsResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("is_deleted");
            StoneSerializers.boolean_().serialize((Boolean)value.isDeleted, g);
            g.writeFieldName("entries");
            StoneSerializers.list(FileMetadata.Serializer.INSTANCE).serialize(value.entries, g);
            if (value.serverDeleted != null) {
                g.writeFieldName("server_deleted");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.serverDeleted, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListRevisionsResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_serverDeleted;
            List<FileMetadata> f_entries;
            Boolean f_isDeleted;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_isDeleted = null;
                f_entries = null;
                f_serverDeleted = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("is_deleted".equals(field)) {
                        f_isDeleted = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("entries".equals(field)) {
                        f_entries = StoneSerializers.list(FileMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("server_deleted".equals(field)) {
                        f_serverDeleted = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_isDeleted == null) {
                    throw new JsonParseException(p, "Required field \"is_deleted\" missing.");
                }
                if (f_entries == null) {
                    throw new JsonParseException(p, "Required field \"entries\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListRevisionsResult value = new ListRevisionsResult(f_isDeleted, f_entries, f_serverDeleted);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

