/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.BaseItem;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.Root;
import org.nuxeo.onedrive.client.types.SharePointIds;
import org.nuxeo.onedrive.client.types.SiteCollection;

public class Site
extends BaseItem {
    private final Site parent;
    private final SiteIdentifier identifier;

    Site(OneDriveAPI api) {
        super(api);
        this.parent = null;
        this.identifier = null;
    }

    Site(OneDriveAPI api, String id, SiteIdentifier identifier) {
        super(api, id);
        this.parent = null;
        this.identifier = identifier;
    }

    Site(Site parent, String id, SiteIdentifier identifier) {
        super(parent.getApi(), id);
        this.parent = parent;
        this.identifier = identifier;
    }

    public static Site byId(OneDriveAPI api, String id) {
        return new Site(api, id, SiteIdentifier.Id);
    }

    public static Site byId(Site parent, String id) {
        return new Site(parent, id, SiteIdentifier.Id);
    }

    public static Site byHostname(OneDriveAPI api, String hostname) {
        return new Site(api, hostname, null);
    }

    public static Site byPath(Site site, String path) {
        return new Site(site, path, SiteIdentifier.Path);
    }

    @Override
    public String getPath() {
        if (this.identifier == null) {
            return "/sites/" + this.getId();
        }
        String path = this.identifier == SiteIdentifier.Path ? ":" + this.getId() : "/sites/" + this.getId();
        if (null != this.parent) {
            return this.parent.getAction(path);
        }
        return path;
    }

    @Deprecated
    public String getBasePath() {
        return this.getPath();
    }

    @Override
    public String getAction(String action) {
        String path = this.getPath();
        if (SiteIdentifier.Path == this.identifier) {
            path = path + ":";
        }
        return path + action;
    }

    @Override
    public Metadata getMetadata() throws IOException {
        URL url = new URLTemplate(this.getBasePath()).build(this.getApi().getBaseURL());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        try (OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());){
            JsonObject jsonObject = response.getContent();
            Metadata metadata = (Metadata)new Metadata().fromJson(jsonObject);
            return metadata;
        }
    }

    @Deprecated
    public String getActionPath(String action) {
        String path = this.getBasePath();
        if (this.identifier == SiteIdentifier.Path) {
            path = path + ":";
        }
        path = path + "/" + action;
        return path;
    }

    private boolean isRoot() {
        return null == this.getId() && null == this.identifier;
    }

    public static Metadata fromJson(OneDriveAPI api, JsonObject jsonObject) {
        String id = jsonObject.get("id").asString();
        return (Metadata)new Site(api, id, SiteIdentifier.Id).new Metadata().fromJson(jsonObject);
    }

    public class Metadata
    extends BaseItem.Metadata<Metadata> {
        private Root root;
        private SharePointIds sharepointIds;
        private SiteCollection siteCollection;
        private String displayName;
        private Drive.Metadata drive;
        private List<Drive.Metadata> drives;
        private List<Metadata> sites;

        public Metadata() {
            super(Site.this);
        }

        public Root getRoot() {
            return this.root;
        }

        public SharePointIds getSharepointIds() {
            return this.sharepointIds;
        }

        public SiteCollection getSiteCollection() {
            return this.siteCollection;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Drive.Metadata getDrive() {
            return this.drive;
        }

        public List<Drive.Metadata> getDrives() {
            return this.drives;
        }

        public List<Metadata> getSites() {
            return this.sites;
        }

        @Override
        public Site getItem() {
            return Site.this;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            JsonValue value;
            String name = member.getName();
            if (this.parseProperty(name, value = member.getValue())) {
                return;
            }
            if (this.parseRelation(name, value)) {
                return;
            }
            super.parseMember(member);
        }

        private boolean parseProperty(String name, JsonValue value) {
            switch (name) {
                case "root": {
                    this.root = (Root)new Root().fromJson(value.asObject());
                    break;
                }
                case "sharepointIds": {
                    this.sharepointIds = (SharePointIds)new SharePointIds().fromJson(value.asObject());
                    break;
                }
                case "siteCollection": {
                    this.siteCollection = (SiteCollection)new SiteCollection().fromJson(value.asObject());
                    break;
                }
                case "displayName": {
                    this.displayName = value.asString();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private boolean parseRelation(String name, JsonValue value) {
            switch (name) {
                case "analytics": {
                    break;
                }
                case "contentTypes": {
                    break;
                }
                case "drive": {
                    this.drive = this.parseDrive(value.asObject());
                    break;
                }
                case "drives": {
                    this.drives = this.parseDrives(value.asArray());
                    break;
                }
                case "items": {
                    break;
                }
                case "lists": {
                    break;
                }
                case "sites": {
                    this.sites = this.parseSites(value.asArray());
                    break;
                }
                case "columns": {
                    break;
                }
                case "oneNote": {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private Drive.Metadata parseDrive(JsonObject jsonObject) {
            String id = jsonObject.get("id").asString();
            return (Drive.Metadata)new Drive(Site.this.getApi(), id).new Drive.Metadata().fromJson(jsonObject);
        }

        private List<Drive.Metadata> parseDrives(JsonArray jsonArray) {
            ArrayList<Drive.Metadata> drives = new ArrayList<Drive.Metadata>(jsonArray.size());
            jsonArray.forEach(v -> drives.add(this.parseDrive(v.asObject())));
            return drives;
        }

        private List<Metadata> parseSites(JsonArray jsonArray) {
            ArrayList<Metadata> sites = new ArrayList<Metadata>(jsonArray.size());
            jsonArray.forEach(v -> sites.add(Site.fromJson(Site.this.getApi(), v.asObject())));
            jsonArray.forEach(v -> sites.add(Site.fromJson(Site.this.getApi(), v.asObject())));
            return sites;
        }
    }

    private static enum SiteIdentifier {
        Id,
        Path;

    }
}

