/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.rule;

import java.util.Collections;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.rule.IRODSRuleParameter;

public final class IRODSRule {
    private final String ruleAsOriginalText;
    private final List<IRODSRuleParameter> irodsRuleInputParameters;
    private final List<IRODSRuleParameter> irodsRuleOutputParameters;
    private final String ruleBody;

    public static IRODSRule instance(String ruleAsOriginalText, List<IRODSRuleParameter> irodsRuleInputParameters, List<IRODSRuleParameter> irodsRuleOutputParameters, String ruleBody) throws JargonException {
        return new IRODSRule(ruleAsOriginalText, irodsRuleInputParameters, irodsRuleOutputParameters, ruleBody);
    }

    private IRODSRule(String ruleAsOriginalText, List<IRODSRuleParameter> irodsRuleInputParameters, List<IRODSRuleParameter> irodsRuleOutputParameters, String ruleBody) throws JargonException {
        if (ruleAsOriginalText == null || ruleAsOriginalText.isEmpty()) {
            throw new JargonException("null or empty ruleAsOriginalText");
        }
        if (irodsRuleInputParameters == null) {
            throw new JargonException("null irodsRuleInputParameters");
        }
        if (irodsRuleOutputParameters == null) {
            throw new JargonException("null irodsRuleOutputParameters");
        }
        if (ruleBody == null || ruleBody.isEmpty()) {
            throw new JargonException("null or empty ruleBody");
        }
        this.ruleAsOriginalText = ruleAsOriginalText;
        this.irodsRuleInputParameters = Collections.unmodifiableList(irodsRuleInputParameters);
        this.irodsRuleOutputParameters = Collections.unmodifiableList(irodsRuleOutputParameters);
        this.ruleBody = ruleBody;
    }

    public String getRuleAsOriginalText() {
        return this.ruleAsOriginalText;
    }

    public List<IRODSRuleParameter> getIrodsRuleInputParameters() {
        return this.irodsRuleInputParameters;
    }

    public List<IRODSRuleParameter> getIrodsRuleOutputParameters() {
        return this.irodsRuleOutputParameters;
    }

    public String getRuleBody() {
        return this.ruleBody;
    }
}

