/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.IOException;
import java.io.InputStream;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IrodsVersion;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ExecCmdStreamClose;
import org.irods.jargon.core.packinstr.ExecCmdStreamClose419;
import org.irods.jargon.core.packinstr.FileReadInp;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecutionBinaryResultInputStream
extends InputStream {
    public static final Logger log = LoggerFactory.getLogger(RemoteExecutionBinaryResultInputStream.class);
    private final AbstractIRODSMidLevelProtocol irodsCommands;
    private final int fileDescriptor;

    public int getFileDescriptor() {
        return this.fileDescriptor;
    }

    @Override
    public int available() throws IOException {
        return 1;
    }

    @Override
    public void close() throws IOException {
        log.info("closing input stream");
        try {
            IrodsVersion irodsVersion = this.irodsCommands.getIRODSServerProperties().getIrodsVersion();
            if (irodsVersion.hasVersionOfAtLeast("rods4.1.9")) {
                log.debug("using 4.1.9 and later close");
                ExecCmdStreamClose419 execCmdStreamClose = ExecCmdStreamClose419.instance(this.fileDescriptor, "");
                this.irodsCommands.irodsFunction(execCmdStreamClose);
            } else {
                log.debug("using pre4.1.9 close");
                ExecCmdStreamClose execCmdStreamClose = ExecCmdStreamClose.instance(this.fileDescriptor);
                this.irodsCommands.irodsFunction(execCmdStreamClose);
            }
        }
        catch (JargonException e) {
            log.error("Jargon exception will be rethrown as an IOException for the method contracts", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark is not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            log.info("stream read for fd: {}", (Object)this.fileDescriptor);
            if (this.fileDescriptor <= 0) {
                throw new IllegalArgumentException("invalid file descriptor");
            }
            if (len < 0) {
                throw new IllegalArgumentException("invalid len");
            }
            FileReadInp fileReadInp = FileReadInp.instanceForReadStream(this.fileDescriptor, len);
            Tag message = this.irodsCommands.irodsFunction(fileReadInp);
            if (message == null) {
                log.warn("null response from iRODS on send of command, treat as eof");
                return -1;
            }
            int buffLength = message.getTag("MsgHeader_PI").getTag("bsLen").getIntValue();
            int read = this.irodsCommands.read(b, off, buffLength);
            if (read != message.getTag("MsgHeader_PI").getTag("intInfo").getIntValue()) {
                log.error("did not read length equal to response length, expected" + buffLength + " bytes actually read:" + read);
                throw new IOException("Bytes read mismatch");
            }
            if (read < 0) {
                return -1;
            }
            return read;
        }
        catch (JargonException e) {
            log.error("JargonException in read is converted to IOException for method contract", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset is not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            throw new IllegalArgumentException("attempt to skip a neg or zero amount");
        }
        int skippedSoFar = 0;
        int read = 0;
        while (read > -1 && (long)skippedSoFar < n) {
            read = this.read(new byte[(int)n]);
            if (read <= -1) continue;
            skippedSoFar += read;
        }
        return skippedSoFar;
    }

    public RemoteExecutionBinaryResultInputStream(AbstractIRODSMidLevelProtocol irodsCommands, int fileDescriptor) {
        if (irodsCommands == null) {
            throw new IllegalArgumentException("null irodsCommands");
        }
        if (fileDescriptor <= 0) {
            throw new IllegalArgumentException("negative or zero file descriptor for stream");
        }
        this.irodsCommands = irodsCommands;
        this.fileDescriptor = fileDescriptor;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.read(buffer, 0, 1);
        if (read > -1) {
            return buffer[0] & 0xFF;
        }
        return -1;
    }
}

