/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.GeneralAdminInp;
import org.irods.jargon.core.pub.domain.Resource;

public class GeneralAdminInpForResources
extends GeneralAdminInp {
    public static final GeneralAdminInpForResources instanceForAddResource(Resource resource) throws JargonException {
        String hostPath;
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        if (resource.getName() == null || resource.getName().isEmpty()) {
            throw new IllegalArgumentException("resource name is null or empty");
        }
        if (resource.getContextString() == null) {
            throw new IllegalArgumentException("Null or empty context string");
        }
        if (resource.getLocation() == null) {
            throw new IllegalArgumentException("context is null");
        }
        if (resource.getVaultPath() == null) {
            throw new IllegalArgumentException("vaultPath is null");
        }
        if (resource.getType() == null || resource.getType().isEmpty()) {
            throw new IllegalArgumentException("null type");
        }
        if (resource.getLocation().isEmpty() || resource.getVaultPath().isEmpty()) {
            if (!resource.getLocation().isEmpty()) {
                throw new IllegalArgumentException("location is not empty but vault path is unspecified");
            }
            if (!resource.getVaultPath().isEmpty()) {
                throw new IllegalArgumentException("vault path is not empty, but resource is unspecified");
            }
            hostPath = "";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(resource.getLocation().trim());
            sb.append(':');
            sb.append(resource.getVaultPath().trim());
            hostPath = sb.toString();
        }
        return new GeneralAdminInpForResources("add", "resource", resource.getName(), resource.getType(), hostPath, resource.getContextString(), "", "", "", "", 701);
    }

    public static final GeneralAdminInpForResources instanceForModifyResource(Resource resource, String option) throws JargonException {
        String newValue;
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        if (resource.getName() == null || resource.getName().isEmpty()) {
            throw new IllegalArgumentException("resource name is null or empty");
        }
        switch (option) {
            case "type": {
                if (resource.getType() == null || resource.getType().isEmpty()) {
                    throw new IllegalArgumentException("null or empty type");
                }
                newValue = resource.getType();
                break;
            }
            case "status": {
                if (resource.getStatus() == null) {
                    throw new IllegalArgumentException("null status");
                }
                newValue = resource.getStatus();
                break;
            }
            case "comment": {
                if (resource.getComment() == null) {
                    throw new IllegalArgumentException("null comment string");
                }
                newValue = resource.getComment();
                break;
            }
            case "info": {
                if (resource.getInfo() == null) {
                    throw new IllegalArgumentException("null info string");
                }
                newValue = resource.getInfo();
                break;
            }
            case "context": {
                if (resource.getContextString() == null) {
                    throw new IllegalArgumentException("Null context string");
                }
                newValue = resource.getContextString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Impossible to change " + option + " attribute for resource " + resource.getName());
            }
        }
        return new GeneralAdminInpForResources("modify", "resource", resource.getName(), option, newValue, "", "", "", "", "", 701);
    }

    public static final GeneralAdminInpForResources instanceForAddChildToResource(String childResourceName, String parentResourceName, String context) throws JargonException {
        if (childResourceName == null || childResourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty childResourceName");
        }
        if (parentResourceName == null || parentResourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty parentResourceName");
        }
        if (context == null) {
            throw new IllegalArgumentException("null  context");
        }
        return new GeneralAdminInpForResources("add", "childtoresc", parentResourceName, childResourceName, context, "", "", "", "", "", 701);
    }

    public static final GeneralAdminInpForResources instanceForRemoveChildFromResource(String childResourceName, String parentResourceName) throws JargonException {
        if (childResourceName == null || childResourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty childResourceName");
        }
        if (parentResourceName == null || parentResourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty parentResourceName");
        }
        return new GeneralAdminInpForResources("rm", "childfromresc", parentResourceName, childResourceName, "", "", "", "", "", "", 701);
    }

    public static final GeneralAdminInpForResources instanceForRemoveResource(String resourceName) throws JargonException {
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        return new GeneralAdminInpForResources("rm", "resource", resourceName, "", "", "", "", "", "", "", 701);
    }

    private GeneralAdminInpForResources(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, String arg8, String arg9, int apiNumber) throws JargonException {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, apiNumber);
    }
}

