/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.irods.jargon.core.connection.AbstractConnection;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IrodsVersion;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.SSLEndInp;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSMidLevelProtocol
extends AbstractIRODSMidLevelProtocol {
    Logger log = LoggerFactory.getLogger(IRODSMidLevelProtocol.class);

    protected IRODSMidLevelProtocol(AbstractConnection irodsConnection, IRODSProtocolManager irodsProtocolManager) {
        super(irodsConnection, irodsProtocolManager);
    }

    protected void finalize() throws Throwable {
        if (this.getIrodsConnection().isConnected()) {
            this.log.error("**************************************************************************************");
            this.log.error("********  WARNING: POTENTIAL CONNECTION LEAK  ******************");
            this.log.error("********  finalizer has run and found a connection left opened, please check your code to ensure that all connections are closed");
            this.log.error("********  IRODSCommands is:{}", (Object)this);
            this.log.error("********  connection is:{}, will attempt to disconnect and shut down any restart thread", (Object)this.getIrodsConnection().getConnectionInternalIdentifier());
            this.log.error("**************************************************************************************");
            this.obliterateConnectionAndDiscardErrors();
        }
        super.finalize();
    }

    @Override
    synchronized void closeOutSocketAndSetAsDisconnected() throws IOException {
        this.getIrodsConnection().getConnection().close();
        this.getIrodsConnection().setConnected(false);
    }

    boolean isPamFlush() {
        if (this.getPipelineConfiguration().isForcePamFlush()) {
            return true;
        }
        IrodsVersion currentVersion = new IrodsVersion(this.getStartupResponseData().getRelVersion());
        if (currentVersion.getMajor() == 4 && currentVersion.getMinor() == 0) {
            this.log.warn("using the pam flush behavior because of iRODS 4.0.X-ness - see https://github.com/DICE-UNC/jargon/issues/70");
            return true;
        }
        return false;
    }

    @Override
    public synchronized Tag irodsFunction(String type, String message, byte[] errorBytes, int errorOffset, int errorLength, byte[] bytes, int byteOffset, int byteBufferLength, int intInfo) throws JargonException {
        this.log.debug("calling irods function with byte array");
        if (intInfo != 1201) {
            this.log.debug("calling irods function with:{}", (Object)message);
        }
        this.log.debug("api number is:{}", (Object)intInfo);
        if (type == null || type.length() == 0) {
            String err = "null or blank type";
            this.log.error(err);
            throw new JargonException(err);
        }
        try {
            int messageLength = 0;
            if (message != null) {
                messageLength = message.getBytes(this.getEncoding()).length;
            }
            this.sendHeader(type, messageLength, errorLength, byteBufferLength, intInfo);
            if (this.getStartupResponseData() == null) {
                this.log.debug("no ssl flush checking during negotiation");
            } else if (this.isPamFlush()) {
                this.log.debug("doing extra pam flush for iRODS 3.2");
                this.getIrodsConnection().flush();
            }
            this.getIrodsConnection().send(message);
            this.getIrodsConnection().flush();
            if (byteBufferLength > 0) {
                this.getIrodsConnection().send(bytes, byteOffset, byteBufferLength);
            }
            this.getIrodsConnection().flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        return this.readMessage();
    }

    @Override
    public synchronized void irodsFunctionUnidirectional(String type, byte[] message, byte[] errorBytes, int errorOffset, int errorLength, byte[] bytes, int byteOffset, int byteBufferLength, int intInfo) throws JargonException {
        this.log.debug("calling irods function with byte array");
        this.log.debug("calling irods function with:{}", (Object)message);
        this.log.debug("api number is:{}", (Object)intInfo);
        if (type == null || type.length() == 0) {
            String err = "null or blank type";
            this.log.error(err);
            throw new JargonException(err);
        }
        try {
            int messageLength = 0;
            if (message != null) {
                messageLength = message.length;
            }
            this.sendHeader(type, messageLength, errorLength, byteBufferLength, intInfo);
            if (this.getStartupResponseData() == null) {
                this.log.debug("no pam flush check during negotiation phase");
            } else if (this.isPamFlush()) {
                this.log.debug("doing extra pam flush for iRODS 3.2");
                this.getIrodsConnection().flush();
            }
            if (messageLength > 0) {
                this.getIrodsConnection().send(message);
                this.getIrodsConnection().flush();
            }
            if (byteBufferLength > 0) {
                this.getIrodsConnection().send(bytes, byteOffset, byteBufferLength);
            }
            this.getIrodsConnection().flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.disconnectWithForce();
            throw new JargonException(e);
        }
    }

    @Override
    public void sendHeader(String type, int messageLength, int errorLength, long byteStringLength, int intInfo) throws JargonException, IOException {
        byte[] header = this.createHeader(type, messageLength, errorLength, byteStringLength, intInfo);
        int len = header.length;
        this.getIrodsConnection().sendInNetworkOrder(len);
        this.getIrodsConnection().send(header);
    }

    @Override
    void preDisconnectAction() throws JargonException {
        this.log.info("preDisconnectAction()");
        if (this.getIrodsConnection().getEncryptionType() == AbstractConnection.EncryptionType.SSL_WRAPPED) {
            this.log.info("sending SSL shutdown if ssl conn");
            SSLEndInp sslEndInp = SSLEndInp.instance();
            this.irodsFunction(sslEndInp);
        }
    }
}

