/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;

public class GoogleStorageLifecycleFeature
implements Lifecycle {
    private static final Logger log = Logger.getLogger(GoogleStorageLifecycleFeature.class);
    private final GoogleStorageSession session;
    private final PathContainerService containerService = new GoogleStoragePathContainerService();

    public GoogleStorageLifecycleFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public void setConfiguration(Path file, LifecycleConfiguration configuration) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            if (configuration.getTransition() != null || configuration.getExpiration() != null) {
                Bucket.Lifecycle config = new Bucket.Lifecycle();
                ArrayList<Bucket.Lifecycle.Rule> rules = new ArrayList<Bucket.Lifecycle.Rule>();
                if (configuration.getTransition() != null) {
                    rules.add(new Bucket.Lifecycle.Rule().setCondition(new Bucket.Lifecycle.Rule.Condition().setIsLive(Boolean.valueOf(true)).setAge(configuration.getTransition())).setAction(new Bucket.Lifecycle.Rule.Action().setType("SetStorageClass").setStorageClass(configuration.getStorageClass())));
                }
                if (configuration.getExpiration() != null) {
                    rules.add(new Bucket.Lifecycle.Rule().setCondition(new Bucket.Lifecycle.Rule.Condition().setIsLive(Boolean.valueOf(true)).setAge(configuration.getExpiration())).setAction(new Bucket.Lifecycle.Rule.Action().setType("Delete")));
                }
                ((Storage)this.session.getClient()).buckets().patch(container.getName(), new Bucket().setLifecycle(config.setRule(rules))).execute();
            } else {
                ((Storage)this.session.getClient()).buckets().patch(container.getName(), new Bucket().setLifecycle(new Bucket.Lifecycle().setRule(Collections.emptyList()))).execute();
            }
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
    }

    public LifecycleConfiguration getConfiguration(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return LifecycleConfiguration.empty();
        }
        if (file.getType().contains(AbstractPath.Type.upload)) {
            return LifecycleConfiguration.empty();
        }
        try {
            Bucket.Lifecycle status = ((Bucket)((Storage)this.session.getClient()).buckets().get(container.getName()).execute()).getLifecycle();
            if (null != status) {
                Integer transition = null;
                Integer expiration = null;
                String storageClass = null;
                for (Bucket.Lifecycle.Rule rule : status.getRule()) {
                    if (!rule.getCondition().getIsLive().booleanValue()) continue;
                    if ("SetStorageClass".equals(rule.getAction().getType())) {
                        transition = rule.getCondition().getAge();
                        storageClass = rule.getAction().getStorageClass();
                    }
                    if (!"Delete".equals(rule.getAction().getType())) continue;
                    expiration = rule.getCondition().getAge();
                }
                return new LifecycleConfiguration(transition, storageClass, expiration);
            }
            return LifecycleConfiguration.empty();
        }
        catch (IOException e) {
            try {
                throw new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, container);
            }
            catch (AccessDeniedException | InteroperabilityException l) {
                log.warn((Object)String.format("Missing permission to read lifecycle configuration for %s %s", container, e.getMessage()));
                return LifecycleConfiguration.empty();
            }
        }
    }
}

