/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoReadFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;

public class CryptoDownloadFeature
implements Download {
    private final Session<?> session;
    private final Download proxy;
    private final Vault vault;

    public CryptoDownloadFeature(Session<?> session, Download proxy, Read reader, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy.withReader((Read)new CryptoReadFeature(session, reader, vault));
        this.vault = vault;
    }

    public void download(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        this.proxy.download(this.vault.encrypt(this.session, file), local, throttle, listener, status, callback);
    }

    public boolean offset(Path file) throws BackgroundException {
        try {
            return this.proxy.offset(this.vault.encrypt(this.session, file));
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Download withReader(Read reader) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoDownloadFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

