/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.GSCredentials;

public class SamplesUtils {
    public static final String SAMPLES_PROPERTIES_NAME = "samples.properties";
    public static final String AWS_ACCESS_KEY_PROPERTY_NAME = "awsAccessKey";
    public static final String AWS_SECRET_KEY_PROPERTY_NAME = "awsSecretKey";
    public static final String GS_ACCESS_KEY_PROPERTY_NAME = "gsAccessKey";
    public static final String GS_SECRET_KEY_PROPERTY_NAME = "gsSecretKey";

    public static AWSCredentials loadAWSCredentials() throws IOException {
        InputStream propertiesIS = ClassLoader.getSystemResourceAsStream(SAMPLES_PROPERTIES_NAME);
        if (propertiesIS == null) {
            throw new RuntimeException("Unable to load test properties file from classpath: samples.properties");
        }
        Properties testProperties = new Properties();
        testProperties.load(propertiesIS);
        if (!testProperties.containsKey(AWS_ACCESS_KEY_PROPERTY_NAME)) {
            throw new RuntimeException("Properties file 'samples.properties' does not contain required property: awsAccessKey");
        }
        if (!testProperties.containsKey(AWS_SECRET_KEY_PROPERTY_NAME)) {
            throw new RuntimeException("Properties file 'samples.properties' does not contain required property: awsSecretKey");
        }
        AWSCredentials awsCredentials = new AWSCredentials(testProperties.getProperty(AWS_ACCESS_KEY_PROPERTY_NAME), testProperties.getProperty(AWS_SECRET_KEY_PROPERTY_NAME));
        return awsCredentials;
    }

    public static GSCredentials loadGSCredentials() throws IOException {
        InputStream propertiesIS = ClassLoader.getSystemResourceAsStream(SAMPLES_PROPERTIES_NAME);
        if (propertiesIS == null) {
            throw new RuntimeException("Unable to load test properties file from classpath: samples.properties");
        }
        Properties testProperties = new Properties();
        testProperties.load(propertiesIS);
        if (!testProperties.containsKey(GS_ACCESS_KEY_PROPERTY_NAME)) {
            throw new RuntimeException("Properties file 'samples.properties' does not contain required property: gsAccessKey");
        }
        if (!testProperties.containsKey(GS_SECRET_KEY_PROPERTY_NAME)) {
            throw new RuntimeException("Properties file 'samples.properties' does not contain required property: gsSecretKey");
        }
        GSCredentials gsCredentials = new GSCredentials(testProperties.getProperty(GS_ACCESS_KEY_PROPERTY_NAME), testProperties.getProperty(GS_SECRET_KEY_PROPERTY_NAME));
        return gsCredentials;
    }
}

