/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.PrivateKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;

public class TripleCryptConverter {
    public static FileKey toSwaggerFileKey(EncryptedFileKey k) {
        return new FileKey().key(k.getKey()).iv(k.getIv()).tag(k.getTag()).version(k.getVersion().getValue());
    }

    public static FileKey toSwaggerFileKey(PlainFileKey k) {
        return new FileKey().key(k.getKey()).iv(k.getIv()).tag(k.getTag()).version(k.getVersion().getValue());
    }

    public static UserKeyPairContainer toSwaggerUserKeyPairContainer(UserKeyPair pair) {
        UserKeyPairContainer container = new UserKeyPairContainer();
        container.setPrivateKeyContainer(new PrivateKeyContainer().privateKey(pair.getUserPrivateKey().getPrivateKey()).version(pair.getUserPrivateKey().getVersion().getValue()));
        container.setPublicKeyContainer(new PublicKeyContainer().publicKey(pair.getUserPublicKey().getPublicKey()).version(pair.getUserPublicKey().getVersion().getValue()));
        return container;
    }

    public static UserKeyPair toCryptoUserKeyPair(UserKeyPairContainer c) throws UnknownVersionException {
        UserPrivateKey privateKey = new UserPrivateKey(UserKeyPair.Version.getByValue((String)c.getPrivateKeyContainer().getVersion()), c.getPrivateKeyContainer().getPrivateKey());
        UserPublicKey publicKey = new UserPublicKey(UserKeyPair.Version.getByValue((String)c.getPublicKeyContainer().getVersion()), c.getPublicKeyContainer().getPublicKey());
        return new UserKeyPair(privateKey, publicKey);
    }

    public static UserPublicKey toCryptoUserPublicKey(PublicKeyContainer c) throws UnknownVersionException {
        return new UserPublicKey(UserKeyPair.Version.getByValue((String)c.getVersion()), c.getPublicKey());
    }

    public static UserPrivateKey toCryptoUserPrivateKey(PrivateKeyContainer c) throws UnknownVersionException {
        return new UserPrivateKey(UserKeyPair.Version.getByValue((String)c.getVersion()), c.getPrivateKey());
    }

    public static PlainFileKey toCryptoPlainFileKey(FileKey key) throws UnknownVersionException {
        PlainFileKey fileKey = new PlainFileKey(PlainFileKey.Version.getByValue((String)key.getVersion()), key.getKey(), key.getIv());
        fileKey.setTag(key.getTag());
        return fileKey;
    }

    public static EncryptedFileKey toCryptoEncryptedFileKey(FileKeyContainer key) throws UnknownVersionException {
        EncryptedFileKey fileKey = new EncryptedFileKey(EncryptedFileKey.Version.getByValue((String)key.getVersion()), key.getKey(), key.getIv());
        fileKey.setTag(key.getTag());
        return fileKey;
    }

    public static EncryptedFileKey toCryptoEncryptedFileKey(FileKey k) throws UnknownVersionException {
        EncryptedFileKey key = new EncryptedFileKey(EncryptedFileKey.Version.getByValue((String)k.getVersion()), k.getKey(), k.getIv());
        key.setTag(k.getTag());
        return key;
    }
}

