/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Request model for creating an Active Directory configuration")
public class CreateActiveDirectoryConfigRequest {
    @JsonProperty(value="alias")
    private String alias = null;
    @JsonProperty(value="serverIp")
    private String serverIp = null;
    @JsonProperty(value="serverPort")
    private Integer serverPort = null;
    @JsonProperty(value="serverAdminName")
    private String serverAdminName = null;
    @JsonProperty(value="serverAdminPassword")
    private String serverAdminPassword = null;
    @JsonProperty(value="ldapUsersDomain")
    private String ldapUsersDomain = null;
    @JsonProperty(value="userFilter")
    private String userFilter = null;
    @JsonProperty(value="userImport")
    private Boolean userImport = false;
    @JsonProperty(value="useLdaps")
    private Boolean useLdaps = false;
    @JsonProperty(value="adExportGroup")
    private String adExportGroup = null;
    @JsonProperty(value="sdsImportGroup")
    private Long sdsImportGroup = null;
    @JsonProperty(value="createHomeFolder")
    private Boolean createHomeFolder = false;
    @JsonProperty(value="homeFolderParent")
    private Long homeFolderParent = null;
    @JsonProperty(value="sslFingerPrint")
    private String sslFingerPrint = null;

    public CreateActiveDirectoryConfigRequest alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(required=true, description="Unique name for an Active Directory configuration")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public CreateActiveDirectoryConfigRequest serverIp(String serverIp) {
        this.serverIp = serverIp;
        return this;
    }

    @Schema(required=true, description="IPv4 or IPv6 address or host name")
    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public CreateActiveDirectoryConfigRequest serverPort(Integer serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    @Schema(required=true, description="Port")
    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public CreateActiveDirectoryConfigRequest serverAdminName(String serverAdminName) {
        this.serverAdminName = serverAdminName;
        return this;
    }

    @Schema(required=true, description="Distinguished Name (DN) of Active Directory administrative account")
    public String getServerAdminName() {
        return this.serverAdminName;
    }

    public void setServerAdminName(String serverAdminName) {
        this.serverAdminName = serverAdminName;
    }

    public CreateActiveDirectoryConfigRequest serverAdminPassword(String serverAdminPassword) {
        this.serverAdminPassword = serverAdminPassword;
        return this;
    }

    @Schema(required=true, description="Password of Active Directory administrative account")
    public String getServerAdminPassword() {
        return this.serverAdminPassword;
    }

    public void setServerAdminPassword(String serverAdminPassword) {
        this.serverAdminPassword = serverAdminPassword;
    }

    public CreateActiveDirectoryConfigRequest ldapUsersDomain(String ldapUsersDomain) {
        this.ldapUsersDomain = ldapUsersDomain;
        return this;
    }

    @Schema(required=true, description="Search scope of Active Directory; only users below this node can log on.")
    public String getLdapUsersDomain() {
        return this.ldapUsersDomain;
    }

    public void setLdapUsersDomain(String ldapUsersDomain) {
        this.ldapUsersDomain = ldapUsersDomain;
    }

    public CreateActiveDirectoryConfigRequest userFilter(String userFilter) {
        this.userFilter = userFilter;
        return this;
    }

    @Schema(required=true, description="Name of Active Directory attribute that is used as login name.")
    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public CreateActiveDirectoryConfigRequest userImport(Boolean userImport) {
        this.userImport = userImport;
        return this;
    }

    @Schema(description="Determines if a DRACOON account is automatically created for a new user  who successfully logs on with his / her AD / IDP account.")
    public Boolean isUserImport() {
        return this.userImport;
    }

    public void setUserImport(Boolean userImport) {
        this.userImport = userImport;
    }

    public CreateActiveDirectoryConfigRequest useLdaps(Boolean useLdaps) {
        this.useLdaps = useLdaps;
        return this;
    }

    @Schema(description="Determines whether LDAPS should be used instead of plain LDAP.")
    public Boolean isUseLdaps() {
        return this.useLdaps;
    }

    public void setUseLdaps(Boolean useLdaps) {
        this.useLdaps = useLdaps;
    }

    public CreateActiveDirectoryConfigRequest adExportGroup(String adExportGroup) {
        this.adExportGroup = adExportGroup;
        return this;
    }

    @Schema(description="If `userImport` is set to `true`,  the user must be member of this Active Directory group to receive a newly created DRACOON account.")
    public String getAdExportGroup() {
        return this.adExportGroup;
    }

    public void setAdExportGroup(String adExportGroup) {
        this.adExportGroup = adExportGroup;
    }

    public CreateActiveDirectoryConfigRequest sdsImportGroup(Long sdsImportGroup) {
        this.sdsImportGroup = sdsImportGroup;
        return this;
    }

    @Schema(description="User group that is assigned to users who are created by automatic import.  Reset with `0`")
    public Long getSdsImportGroup() {
        return this.sdsImportGroup;
    }

    public void setSdsImportGroup(Long sdsImportGroup) {
        this.sdsImportGroup = sdsImportGroup;
    }

    public CreateActiveDirectoryConfigRequest createHomeFolder(Boolean createHomeFolder) {
        this.createHomeFolder = createHomeFolder;
        return this;
    }

    @Schema(description="DEPRECATED, will be ignored  Determines whether a room is created for each user that is created by automatic import (like a home folder).  Room's name will equal the user's login name.")
    public Boolean isCreateHomeFolder() {
        return this.createHomeFolder;
    }

    public void setCreateHomeFolder(Boolean createHomeFolder) {
        this.createHomeFolder = createHomeFolder;
    }

    public CreateActiveDirectoryConfigRequest homeFolderParent(Long homeFolderParent) {
        this.homeFolderParent = homeFolderParent;
        return this;
    }

    @Schema(description="DEPRECATED, will be ignored  ID of the room in which the individual rooms for users will be created.")
    public Long getHomeFolderParent() {
        return this.homeFolderParent;
    }

    public void setHomeFolderParent(Long homeFolderParent) {
        this.homeFolderParent = homeFolderParent;
    }

    public CreateActiveDirectoryConfigRequest sslFingerPrint(String sslFingerPrint) {
        this.sslFingerPrint = sslFingerPrint;
        return this;
    }

    @Schema(description="SSL finger print of Active Directory server.  Mandatory for LDAPS connections.  Format: `Algorithm/Fingerprint`")
    public String getSslFingerPrint() {
        return this.sslFingerPrint;
    }

    public void setSslFingerPrint(String sslFingerPrint) {
        this.sslFingerPrint = sslFingerPrint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateActiveDirectoryConfigRequest createActiveDirectoryConfigRequest = (CreateActiveDirectoryConfigRequest)o;
        return Objects.equals(this.alias, createActiveDirectoryConfigRequest.alias) && Objects.equals(this.serverIp, createActiveDirectoryConfigRequest.serverIp) && Objects.equals(this.serverPort, createActiveDirectoryConfigRequest.serverPort) && Objects.equals(this.serverAdminName, createActiveDirectoryConfigRequest.serverAdminName) && Objects.equals(this.serverAdminPassword, createActiveDirectoryConfigRequest.serverAdminPassword) && Objects.equals(this.ldapUsersDomain, createActiveDirectoryConfigRequest.ldapUsersDomain) && Objects.equals(this.userFilter, createActiveDirectoryConfigRequest.userFilter) && Objects.equals(this.userImport, createActiveDirectoryConfigRequest.userImport) && Objects.equals(this.useLdaps, createActiveDirectoryConfigRequest.useLdaps) && Objects.equals(this.adExportGroup, createActiveDirectoryConfigRequest.adExportGroup) && Objects.equals(this.sdsImportGroup, createActiveDirectoryConfigRequest.sdsImportGroup) && Objects.equals(this.createHomeFolder, createActiveDirectoryConfigRequest.createHomeFolder) && Objects.equals(this.homeFolderParent, createActiveDirectoryConfigRequest.homeFolderParent) && Objects.equals(this.sslFingerPrint, createActiveDirectoryConfigRequest.sslFingerPrint);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.serverIp, this.serverPort, this.serverAdminName, this.serverAdminPassword, this.ldapUsersDomain, this.userFilter, this.userImport, this.useLdaps, this.adExportGroup, this.sdsImportGroup, this.createHomeFolder, this.homeFolderParent, this.sslFingerPrint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateActiveDirectoryConfigRequest {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    serverIp: ").append(this.toIndentedString(this.serverIp)).append("\n");
        sb.append("    serverPort: ").append(this.toIndentedString(this.serverPort)).append("\n");
        sb.append("    serverAdminName: ").append(this.toIndentedString(this.serverAdminName)).append("\n");
        sb.append("    serverAdminPassword: ").append(this.toIndentedString(this.serverAdminPassword)).append("\n");
        sb.append("    ldapUsersDomain: ").append(this.toIndentedString(this.ldapUsersDomain)).append("\n");
        sb.append("    userFilter: ").append(this.toIndentedString(this.userFilter)).append("\n");
        sb.append("    userImport: ").append(this.toIndentedString(this.userImport)).append("\n");
        sb.append("    useLdaps: ").append(this.toIndentedString(this.useLdaps)).append("\n");
        sb.append("    adExportGroup: ").append(this.toIndentedString(this.adExportGroup)).append("\n");
        sb.append("    sdsImportGroup: ").append(this.toIndentedString(this.sdsImportGroup)).append("\n");
        sb.append("    createHomeFolder: ").append(this.toIndentedString(this.createHomeFolder)).append("\n");
        sb.append("    homeFolderParent: ").append(this.toIndentedString(this.homeFolderParent)).append("\n");
        sb.append("    sslFingerPrint: ").append(this.toIndentedString(this.sslFingerPrint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

