/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Metric;
import cc.mallet.types.SparseVector;

public class Minkowski
implements Metric {
    double q;

    public Minkowski(double q) {
        if (q < 1.0) {
            throw new IllegalArgumentException("Argument q must be at least 1.");
        }
        this.q = q;
    }

    public double distance(SparseVector a, SparseVector b) {
        double dist = 0.0;
        if (a == null || b == null) {
            throw new IllegalArgumentException("Distance from a null vector is undefined.");
        }
        if (a.numLocations() != b.numLocations()) {
            throw new IllegalArgumentException("Vectors must be of the same dimension.");
        }
        for (int i = 0; i < a.numLocations(); ++i) {
            double diff = Math.abs(a.valueAtLocation(i) - b.valueAtLocation(i));
            if (this.q == 1.0) {
                dist += diff;
                continue;
            }
            if (this.q == 2.0) {
                dist += diff * diff;
                continue;
            }
            if (this.q != Double.POSITIVE_INFINITY) continue;
            if (diff > dist) {
                dist = diff;
                continue;
            }
            dist += Math.pow(diff, this.q);
        }
        if (this.q == 1.0 || this.q == Double.POSITIVE_INFINITY) {
            return dist;
        }
        if (this.q == 2.0) {
            return Math.sqrt(dist);
        }
        return Math.pow(dist, 1.0 / this.q);
    }

    public double euclideanDistance(SparseVector a, SparseVector b) {
        double diff;
        double dist = 0.0;
        if (a == null || b == null) {
            throw new IllegalArgumentException("Distance from a null vector is undefined.");
        }
        int aLen = a.numLocations();
        int bLen = b.numLocations();
        int ia = 0;
        int ib = 0;
        while (ia < aLen && ib < bLen) {
            int indiceb;
            int indicea = a.indexAtLocation(ia);
            if (indicea < (indiceb = b.indexAtLocation(ib))) {
                diff = a.valueAtLocation(ia);
                ++ia;
            } else if (indicea == indiceb) {
                diff = Math.abs(a.valueAtLocation(ia) - b.valueAtLocation(ib));
                ++ia;
                ++ib;
            } else {
                diff = b.valueAtLocation(ib);
                ++ib;
            }
            dist += diff * diff;
        }
        while (ia < aLen) {
            diff = a.valueAtLocation(ia);
            dist += diff * diff;
        }
        while (ib < bLen) {
            diff = b.valueAtLocation(ib);
            dist += diff * diff;
        }
        dist = Math.sqrt(dist);
        return dist;
    }
}

