/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.classify.Classification;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.util.PropertyList;

public class Classification2ConfidencePredictingFeatureVector
extends Pipe {
    public Classification2ConfidencePredictingFeatureVector() {
        super(new Alphabet(), new LabelAlphabet());
    }

    public Instance pipe(Instance carrier) {
        Classification classification = (Classification)carrier.getData();
        PropertyList features = null;
        LabelVector lv = classification.getLabelVector();
        Label bestLabel = lv.getBestLabel();
        Instance inst = classification.getInstance();
        FeatureVector fv = (FeatureVector)inst.getData();
        Alphabet fdict = fv.getAlphabet();
        double winningThreshold = 0.99;
        double varianceThreshold = 0.15;
        double secondThreshold = 0.03;
        double winningScore = lv.getValueAtRank(0);
        double marginOfVictory = winningScore - lv.getValueAtRank(1);
        features = PropertyList.add("winningScore", winningScore, features);
        features = PropertyList.add("secondScore", lv.getValueAtRank(1), features);
        for (int i = 0; i < lv.numLocations(); ++i) {
            features = PropertyList.add(lv.getLabelAtRank(i).toString() + "HasValue", lv.valueAtLocation(i), features);
        }
        features = PropertyList.add("MarginOfVictory", marginOfVictory, features);
        features = PropertyList.add("numFeatures", (double)fv.numLocations() / (double)fdict.size(), features);
        features = PropertyList.add(bestLabel.toString() + "IsFirst-" + lv.getLabelAtRank(1).toString() + "IsSecond", 1.0, features);
        features = PropertyList.add("Range", winningScore - lv.getValueAtRank(lv.numLocations() - 1), features);
        features = PropertyList.add(bestLabel.toString() + "IsFirst", 1.0, features);
        features = PropertyList.add(lv.getLabelAtRank(1).toString() + "IsSecond", 1.0, features);
        carrier.setTarget(((LabelAlphabet)this.getTargetAlphabet()).lookupLabel(classification.bestLabelIsCorrect() ? "correct" : "incorrect"));
        carrier.setData(new FeatureVector(this.getDataAlphabet(), features, false));
        carrier.setName(inst.getName());
        carrier.setSource(inst.getSource());
        return carrier;
    }

    private double getScoreMean(LabelVector lv) {
        double sum = 0.0;
        for (int i = 0; i < lv.numLocations(); ++i) {
            sum += lv.getValueAtRank(i);
        }
        return sum / (double)lv.numLocations();
    }

    private double getScoreVariance(LabelVector lv) {
        double mean = this.getScoreMean(lv);
        double squaredDifference = 0.0;
        for (int i = 0; i < lv.numLocations(); ++i) {
            squaredDifference += (mean - lv.getValueAtRank(i)) * (mean - lv.getValueAtRank(i));
        }
        return squaredDifference / (double)lv.numLocations();
    }
}

