/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_QualifierTest;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_Heap
extends T_Generic {
    private static final String testService = "heapTest";

    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    protected void runTests() throws T_Fail {
        AccessFactory store = null;
        TransactionController tc = null;
        boolean pass = false;
        this.out.println("executing heap test");
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            store = (AccessFactory)Monitor.createPersistentService((String)this.getModuleToTestProtocolName(), (String)testService, (Properties)this.startParams);
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.REPORT("(unitTestMain) Testing heapTest");
        try {
            tc = store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            if (this.t_001(tc)) {
                pass = true;
            }
            tc.commit();
            tc.destroy();
        }
        catch (StandardException e) {
            System.out.println("got an exception.");
            String msg = e.getMessage();
            if (msg == null) {
                msg = ((Object)((Object)e)).getClass().getName();
            }
            this.REPORT(msg);
            throw T_Fail.exceptionFail(e);
        }
        if (!pass) {
            throw T_Fail.testFailMsg("T_Heap test failed");
        }
    }

    protected boolean t_001(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("Starting t_001");
        T_QualifierTest q_test = new T_QualifierTest("heap", null, false, this.out, 3);
        boolean test_result = q_test.t_testqual(tc);
        if (!test_result) {
            throw T_Fail.testFailMsg("T_Heap.t_001 failed");
        }
        this.REPORT("Ending t_001");
        return test_result;
    }
}

