/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.direct;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derbyTesting.system.oe.client.Display;
import org.apache.derbyTesting.system.oe.client.Operations;
import org.apache.derbyTesting.system.oe.direct.OrderItem4Sort;
import org.apache.derbyTesting.system.oe.direct.StatementHelper;
import org.apache.derbyTesting.system.oe.model.Customer;
import org.apache.derbyTesting.system.oe.model.District;
import org.apache.derbyTesting.system.oe.model.Order;
import org.apache.derbyTesting.system.oe.model.OrderLine;
import org.apache.derbyTesting.system.oe.model.Warehouse;

public class Standard
extends StatementHelper
implements Operations {
    private final Customer customer = new Customer();
    private final Warehouse warehouse = new Warehouse();
    private final District district = new District();
    private final Order order = new Order();
    private final List nameList = new ArrayList();
    private static final String[] STOCK_INFO = new String[]{"SELECT S_QUANTITY, S_DIST_01, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_02, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_03, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_04, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_05, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_06, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_07, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_08, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_09, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?", "SELECT S_QUANTITY, S_DIST_10, S_DATA FROM STOCK WHERE S_I_ID = ? AND S_W_ID = ?"};

    public Standard(Connection conn) throws SQLException {
        super(conn, false, 8);
    }

    public static Operations noReset(Connection conn) throws SQLException {
        return new Standard(conn){

            protected void reset(PreparedStatement ps) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stockLevel(Display display, Object displayData, short w, short d, int threshold) throws Exception {
        int lowStock;
        int isolation = this.conn.getTransactionIsolation();
        try {
            try {
                this.conn.setTransactionIsolation(2);
                PreparedStatement sl1 = this.prepareStatement("SELECT D_NEXT_O_ID FROM DISTRICT WHERE D_W_ID = ? AND D_ID = ?");
                PreparedStatement sl2 = this.prepareStatement("SELECT COUNT(DISTINCT(S_I_ID)) AS LOW_STOCK FROM ORDERLINE, STOCK WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID < ? AND OL_O_ID >= ? AND S_W_ID = ? AND S_I_ID = OL_I_ID AND S_QUANTITY < ?");
                sl1.setShort(1, w);
                sl1.setShort(2, d);
                sl2.setShort(1, w);
                sl2.setShort(2, d);
                sl2.setShort(5, w);
                sl2.setInt(6, threshold);
                ResultSet rs = sl1.executeQuery();
                rs.next();
                int nextOrder = rs.getInt("D_NEXT_O_ID");
                this.reset(sl1);
                sl2.setInt(3, nextOrder);
                sl2.setInt(4, nextOrder - 20);
                rs = sl2.executeQuery();
                rs.next();
                lowStock = rs.getInt("LOW_STOCK");
                this.reset(sl2);
                this.conn.commit();
            }
            finally {
                this.conn.setTransactionIsolation(isolation);
            }
        }
        catch (SQLException sqle) {
            this.conn.rollback();
            this.conn.setTransactionIsolation(isolation);
            throw sqle;
        }
        if (display != null) {
            display.displayStockLevel(displayData, w, d, threshold, lowStock);
        }
    }

    public void orderStatus(Display display, Object displayData, short w, short d, String customerLast) throws Exception {
        PreparedStatement osCustomerByName = this.prepareStatement("SELECT C_ID, C_BALANCE, C_FIRST, C_MIDDLE FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_LAST = ? ORDER BY C_FIRST");
        try {
            osCustomerByName.setShort(1, w);
            osCustomerByName.setShort(2, d);
            osCustomerByName.setString(3, customerLast);
            ResultSet rs = osCustomerByName.executeQuery();
            this.nameList.clear();
            while (rs.next()) {
                Customer customer = new Customer();
                customer.setWarehouse(w);
                customer.setDistrict(d);
                customer.setLast(customerLast);
                customer.setId(rs.getInt("C_ID"));
                customer.setBalance(rs.getString("C_BALANCE"));
                customer.setFirst(rs.getString("C_FIRST"));
                customer.setMiddle(rs.getString("C_MIDDLE"));
                this.nameList.add(customer);
            }
            this.reset(osCustomerByName);
            if (this.nameList.isEmpty()) {
                throw new SQLException("Order Status by name - no matching customer " + customerLast);
            }
            int mid = this.nameList.size() / 2;
            if (mid != 0 && this.nameList.size() % 2 == 1) {
                ++mid;
            }
            Customer customer = (Customer)this.nameList.get(mid);
            this.nameList.clear();
            this.getOrderStatusForCustomer(display, displayData, true, customer);
        }
        catch (SQLException e) {
            this.conn.rollback();
            throw e;
        }
    }

    public void orderStatus(Display display, Object displayData, short w, short d, int c) throws Exception {
        PreparedStatement osCustomerById = this.prepareStatement("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_LAST FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        this.customer.clear();
        this.customer.setWarehouse(w);
        this.customer.setDistrict(d);
        this.customer.setId(c);
        try {
            osCustomerById.setShort(1, w);
            osCustomerById.setShort(2, d);
            osCustomerById.setInt(3, c);
            ResultSet rs = osCustomerById.executeQuery();
            rs.next();
            this.customer.setBalance(rs.getString("C_BALANCE"));
            this.customer.setFirst(rs.getString("C_FIRST"));
            this.customer.setMiddle(rs.getString("C_MIDDLE"));
            this.customer.setLast(rs.getString("C_LAST"));
            this.reset(osCustomerById);
            this.getOrderStatusForCustomer(display, displayData, false, this.customer);
        }
        catch (SQLException e) {
            this.conn.rollback();
            throw e;
        }
    }

    private void getOrderStatusForCustomer(Display display, Object displayData, boolean byName, Customer customer) throws Exception {
        PreparedStatement osLastOrderNumber = this.prepareStatement("SELECT MAX(O_ID) AS LAST_ORDER FROM ORDERS WHERE O_W_ID = ? AND O_D_ID = ? AND O_C_ID = ?");
        PreparedStatement osOrderDetails = this.prepareStatement("SELECT O_ENTRY_D, O_CARRIER_ID, O_OL_CNT FROM ORDERS WHERE O_W_ID = ? AND O_D_ID = ? AND O_ID = ?");
        PreparedStatement osOrderLineItems = this.prepareStatement("SELECT OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DELIVERY_D FROM ORDERLINE WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?");
        this.order.clear();
        this.order.setWarehouse(customer.getWarehouse());
        this.order.setDistrict(customer.getDistrict());
        osLastOrderNumber.setShort(1, customer.getWarehouse());
        osLastOrderNumber.setShort(2, customer.getDistrict());
        osLastOrderNumber.setInt(3, customer.getId());
        ResultSet rs = osLastOrderNumber.executeQuery();
        rs.next();
        this.order.setId(rs.getInt("LAST_ORDER"));
        this.reset(osLastOrderNumber);
        osOrderDetails.setShort(1, customer.getWarehouse());
        osOrderDetails.setShort(2, customer.getDistrict());
        osOrderDetails.setInt(3, this.order.getId());
        rs = osOrderDetails.executeQuery();
        rs.next();
        this.order.setEntry_d(rs.getTimestamp("O_ENTRY_D"));
        this.order.setCarrier_id((Integer)rs.getObject("O_CARRIER_ID"));
        this.order.setOl_cnt(rs.getInt("O_OL_CNT"));
        rs.close();
        OrderLine[] lineItems = new OrderLine[this.order.getOl_cnt()];
        osOrderLineItems.setShort(1, this.order.getWarehouse());
        osOrderLineItems.setShort(2, this.order.getDistrict());
        osOrderLineItems.setInt(3, this.order.getId());
        rs = osOrderLineItems.executeQuery();
        int oli = 0;
        while (rs.next()) {
            OrderLine ol = new OrderLine();
            ol.setI_id(rs.getInt("OL_I_ID"));
            ol.setSupply_w_id(rs.getShort("OL_SUPPLY_W_ID"));
            ol.setQuantity(rs.getShort("OL_QUANTITY"));
            ol.setAmount(rs.getString("OL_AMOUNT"));
            ol.setDelivery_d(rs.getTimestamp("OL_DELIVERY_D"));
            lineItems[oli++] = ol;
        }
        rs.close();
        this.conn.commit();
        if (display != null) {
            display.displayOrderStatus(displayData, byName, customer, this.order, lineItems);
        }
    }

    public void payment(Display display, Object displayData, short w, short d, short cw, short cd, String customerLast, String amount) throws Exception {
        PreparedStatement pyCustomerByName = this.prepareStatement("SELECT C_ID FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_LAST = ? ORDER BY C_FIRST");
        try {
            pyCustomerByName.setShort(1, cw);
            pyCustomerByName.setShort(2, cd);
            pyCustomerByName.setString(3, customerLast);
            ResultSet rs = pyCustomerByName.executeQuery();
            this.nameList.clear();
            while (rs.next()) {
                this.nameList.add(rs.getObject("C_ID"));
            }
            this.reset(pyCustomerByName);
            if (this.nameList.isEmpty()) {
                throw new SQLException("Payment by name - no matching customer " + customerLast);
            }
            int mid = this.nameList.size() / 2;
            if (mid != 0 && this.nameList.size() % 2 == 1) {
                ++mid;
            }
            int c = (Integer)this.nameList.get(mid);
            this.paymentById(display, displayData, w, d, cw, cd, c, amount);
        }
        catch (SQLException e) {
            this.conn.rollback();
            throw e;
        }
        if (display != null) {
            // empty if block
        }
    }

    public void payment(Display display, Object displayData, short w, short d, short cw, short cd, int c, String amount) throws Exception {
        try {
            this.paymentById(display, displayData, w, d, cw, cd, c, amount);
        }
        catch (SQLException e) {
            this.conn.rollback();
            throw e;
        }
        if (display != null) {
            // empty if block
        }
    }

    private void paymentById(Display display, Object displayData, short w, short d, short cw, short cd, int c, String amount) throws Exception {
        PreparedStatement pyCustomerPayment = this.prepareStatement("UPDATE CUSTOMER SET C_BALANCE = C_BALANCE - ?, C_YTD_PAYMENT = C_YTD_PAYMENT + ?, C_PAYMENT_CNT = C_PAYMENT_CNT + 1 WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement pyCustomerInfoId = this.prepareStatement("SELECT C_FIRST, C_MIDDLE, C_LAST, C_BALANCE, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_SINCE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement pyCustomerUpdateBadCredit = this.prepareStatement("UPDATE CUSTOMER SET C_DATA =  BAD_CREDIT_DATA(C_DATA, ?, ?, C_W_ID, C_W_ID, C_ID, ?) WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement pyCustomerGetData = this.prepareStatement("SELECT SUBSTR(C_DATA, 1, 200) AS C_DATA_200 FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        PreparedStatement pyDistrictUpdate = this.prepareStatement("UPDATE DISTRICT SET D_YTD = D_YTD + ? WHERE D_W_ID = ? AND D_ID = ?");
        PreparedStatement pyDistrictInfo = this.prepareStatement("SELECT D_NAME, D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP FROM DISTRICT WHERE D_W_ID = ? AND D_ID = ? ");
        PreparedStatement pyWarehouseUpdate = this.prepareStatement("UPDATE WAREHOUSE SET W_YTD = W_YTD + ? WHERE W_ID = ?");
        PreparedStatement pyWarehouseInfo = this.prepareStatement("SELECT W_NAME, W_STREET_1, W_STREET_2, W_CITY, W_STATE, W_ZIP FROM WAREHOUSE WHERE W_ID = ?");
        PreparedStatement pyHistory = this.prepareStatement("INSERT INTO HISTORY(H_C_ID, H_C_D_ID, H_C_W_ID, H_D_ID, H_W_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, CURRENT TIMESTAMP, ?, ?)");
        Customer customer = new Customer();
        customer.setWarehouse(cw);
        customer.setDistrict(cd);
        customer.setId(c);
        pyCustomerPayment.setString(1, amount);
        pyCustomerPayment.setString(2, amount);
        pyCustomerPayment.setShort(3, cw);
        pyCustomerPayment.setShort(4, cd);
        pyCustomerPayment.setInt(5, c);
        pyCustomerPayment.executeUpdate();
        pyCustomerInfoId.setShort(1, cw);
        pyCustomerInfoId.setShort(2, cd);
        pyCustomerInfoId.setInt(3, c);
        ResultSet rs = pyCustomerInfoId.executeQuery();
        rs.next();
        customer.setFirst(rs.getString("C_FIRST"));
        customer.setMiddle(rs.getString("C_MIDDLE"));
        customer.setLast(rs.getString("C_LAST"));
        customer.setBalance(rs.getString("C_BALANCE"));
        customer.setAddress(this.getAddress(rs, "C_STREET_1"));
        customer.setPhone(rs.getString("C_PHONE"));
        customer.setSince(rs.getTimestamp("C_SINCE"));
        customer.setCredit(rs.getString("C_CREDIT"));
        customer.setCredit_lim(rs.getString("C_CREDIT_LIM"));
        customer.setDiscount(rs.getString("C_DISCOUNT"));
        this.reset(pyCustomerInfoId);
        if ("BC".equals(customer.getCredit())) {
            pyCustomerUpdateBadCredit.setShort(1, w);
            pyCustomerUpdateBadCredit.setShort(2, d);
            pyCustomerUpdateBadCredit.setString(3, amount);
            pyCustomerUpdateBadCredit.setShort(4, cw);
            pyCustomerUpdateBadCredit.setShort(5, cd);
            pyCustomerUpdateBadCredit.setInt(6, c);
            pyCustomerUpdateBadCredit.executeUpdate();
            this.reset(pyCustomerUpdateBadCredit);
            pyCustomerGetData.setShort(1, cw);
            pyCustomerGetData.setShort(2, cd);
            pyCustomerGetData.setInt(3, c);
            rs = pyCustomerGetData.executeQuery();
            rs.next();
            customer.setData(rs.getString("C_DATA_200"));
            this.reset(pyCustomerGetData);
        }
        this.district.clear();
        this.district.setWarehouse(w);
        this.district.setId(d);
        pyDistrictUpdate.setString(1, amount);
        pyDistrictUpdate.setShort(2, w);
        pyDistrictUpdate.setShort(3, d);
        pyDistrictUpdate.executeUpdate();
        this.reset(pyDistrictUpdate);
        pyDistrictInfo.setShort(1, w);
        pyDistrictInfo.setShort(2, d);
        rs = pyDistrictInfo.executeQuery();
        rs.next();
        this.district.setName(rs.getString("D_NAME"));
        this.district.setAddress(this.getAddress(rs, "D_STREET_1"));
        this.reset(pyDistrictInfo);
        this.warehouse.clear();
        this.warehouse.setId(w);
        pyWarehouseUpdate.setString(1, amount);
        pyWarehouseUpdate.setShort(2, w);
        pyWarehouseUpdate.executeUpdate();
        this.reset(pyWarehouseUpdate);
        pyWarehouseInfo.setShort(1, w);
        rs = pyWarehouseInfo.executeQuery();
        rs.next();
        this.warehouse.setName(rs.getString("W_NAME"));
        this.warehouse.setAddress(this.getAddress(rs, "W_STREET_1"));
        this.reset(pyWarehouseInfo);
        pyHistory.setInt(1, c);
        pyHistory.setShort(2, cd);
        pyHistory.setShort(3, cw);
        pyHistory.setShort(4, d);
        pyHistory.setShort(5, w);
        pyHistory.setString(6, amount);
        StringBuffer hData = new StringBuffer(24);
        hData.append(this.warehouse.getName());
        hData.append("    ");
        hData.append(this.district.getName());
        pyHistory.setString(7, hData.toString());
        pyHistory.executeUpdate();
        this.reset(pyHistory);
        this.conn.commit();
    }

    public void newOrder(Display display, Object displayData, short w, short d, int c, int[] items, short[] quantities, short[] supplyW) throws Exception {
        this.sortOrderItems(items, quantities, supplyW);
        try {
            PreparedStatement psWarehouseTax = this.prepareStatement("SELECT W_TAX FROM WAREHOUSE WHERE W_ID = ?");
            psWarehouseTax.setShort(1, w);
            ResultSet rs = psWarehouseTax.executeQuery();
            rs.next();
            BigDecimal warehouseTax = (BigDecimal)rs.getObject(1);
            this.reset(psWarehouseTax);
            PreparedStatement psDistrictUpdate = this.prepareStatement("UPDATE DISTRICT SET D_NEXT_O_ID = D_NEXT_O_ID + 1 WHERE D_W_ID = ? AND D_ID = ?");
            psDistrictUpdate.setShort(1, w);
            psDistrictUpdate.setShort(2, d);
            psDistrictUpdate.executeUpdate();
            this.reset(psDistrictUpdate);
            PreparedStatement psDistrict = this.prepareStatement("SELECT D_NEXT_O_ID - 1, D_TAX FROM DISTRICT WHERE D_W_ID = ? AND D_ID = ?");
            psDistrict.setShort(1, w);
            psDistrict.setShort(2, d);
            rs = psDistrict.executeQuery();
            rs.next();
            int orderNumber = rs.getInt(1);
            BigDecimal districtTax = (BigDecimal)rs.getObject(2);
            this.reset(psDistrict);
            PreparedStatement psCustomer = this.prepareStatement("SELECT C_LAST, C_DISCOUNT, C_CREDIT FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
            psCustomer.setShort(1, w);
            psCustomer.setShort(2, d);
            psCustomer.setInt(3, c);
            rs = psCustomer.executeQuery();
            rs.next();
            this.reset(psCustomer);
            short allLocal = 1;
            for (int i = 0; i < supplyW.length; ++i) {
                if (supplyW[i] == w) continue;
                allLocal = 0;
                break;
            }
            PreparedStatement psOrder = this.prepareStatement("INSERT INTO ORDERS VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP, NULL, ?, ?)");
            psOrder.setInt(1, orderNumber);
            psOrder.setShort(2, d);
            psOrder.setShort(3, w);
            psOrder.setInt(4, c);
            psOrder.setShort(5, (short)items.length);
            psOrder.setShort(6, allLocal);
            psOrder.executeUpdate();
            this.reset(psOrder);
            PreparedStatement psNewOrder = this.prepareStatement("INSERT INTO NEWORDERS VALUES(?, ?, ?)");
            psNewOrder.setInt(1, orderNumber);
            psNewOrder.setShort(2, d);
            psNewOrder.setShort(3, w);
            psNewOrder.executeUpdate();
            this.reset(psNewOrder);
            PreparedStatement psOrderLine = this.prepareStatement("INSERT INTO ORDERLINE(OL_W_ID, OL_D_ID, OL_O_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO, OL_DELIVERY_D) VALUES (?, ?, ?, ?, ?, ?, ?, CAST (? AS DECIMAL(5,2)) * CAST (? AS SMALLINT), ?, NULL)");
            psOrderLine.setShort(1, w);
            psOrderLine.setShort(2, d);
            psOrderLine.setInt(3, orderNumber);
            PreparedStatement psItemPrice = this.prepareStatement("SELECT I_PRICE, I_NAME, I_DATA FROM ITEM WHERE I_ID = ?");
            PreparedStatement psStockUpdate = this.prepareStatement("UPDATE STOCK SET S_ORDER_CNT = S_ORDER_CNT + 1, S_YTD = S_YTD + ?, S_REMOTE_CNT = S_REMOTE_CNT + ?, S_QUANTITY = ? WHERE S_I_ID = ? AND S_W_ID = ?");
            for (int i = 0; i < items.length; ++i) {
                psItemPrice.setInt(1, items[i]);
                rs = psItemPrice.executeQuery();
                rs.next();
                BigDecimal itemPrice = (BigDecimal)rs.getObject(1);
                String itemName = rs.getString(2);
                String itemData = rs.getString(3);
                rs.close();
                PreparedStatement psStockInfo = this.prepareStatement(STOCK_INFO[d - 1]);
                psStockInfo.setInt(1, items[i]);
                psStockInfo.setShort(2, w);
                rs = psStockInfo.executeQuery();
                rs.next();
                int stockQuantity = rs.getInt(1);
                String stockDistInfo = rs.getString(2);
                String stockData = rs.getString(3);
                this.reset(psStockInfo);
                psStockUpdate.setInt(1, quantities[i]);
                psStockUpdate.setInt(2, w == supplyW[i] ? 0 : 1);
                stockQuantity = stockQuantity - quantities[i] > 10 ? (stockQuantity -= quantities[i]) : stockQuantity - quantities[i] + 91;
                psStockUpdate.setInt(3, stockQuantity);
                psStockUpdate.setInt(4, items[i]);
                psStockUpdate.setShort(5, w);
                psStockUpdate.executeUpdate();
                psOrderLine.setShort(4, (short)(i + 1));
                psOrderLine.setInt(5, items[i]);
                psOrderLine.setShort(6, supplyW[i]);
                psOrderLine.setShort(7, quantities[i]);
                psOrderLine.setObject(8, (Object)itemPrice, 3);
                psOrderLine.setShort(9, quantities[i]);
                psOrderLine.setString(10, stockDistInfo);
                psOrderLine.executeUpdate();
            }
            this.reset(psOrderLine);
            this.reset(psItemPrice);
            this.reset(psOrderLine);
            this.reset(psStockUpdate);
            PreparedStatement psTotal = this.prepareStatement("SELECT SUM(OL_AMOUNT) FROM ORDERLINE WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?");
            psTotal.setShort(1, w);
            psTotal.setShort(2, d);
            psTotal.setInt(3, orderNumber);
            rs = psTotal.executeQuery();
            rs.next();
            BigDecimal orderTotal = (BigDecimal)rs.getObject(1);
            this.reset(psTotal);
            this.conn.commit();
        }
        catch (SQLException e) {
            this.conn.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleDelivery(Display display, Object displayData, short w, short carrier) throws Exception {
        PreparedStatement sdSchedule = this.prepareStatement("INSERT INTO DELIVERY_REQUEST(DR_W_ID, DR_CARRIER_ID, DR_STATE) VALUES(?, ?, 'Q')");
        int isolation = this.conn.getTransactionIsolation();
        try {
            this.conn.setTransactionIsolation(2);
            sdSchedule.setShort(1, w);
            sdSchedule.setShort(2, carrier);
            sdSchedule.executeUpdate();
            this.reset(sdSchedule);
            this.conn.commit();
        }
        finally {
            this.conn.setTransactionIsolation(isolation);
        }
        if (display != null) {
            display.displayScheduleDelivery(displayData, w, carrier);
        }
    }

    public void delivery() throws Exception {
        PreparedStatement dlFindOldestRequest = this.prepareStatement("SELECT DR_ID, DR_W_ID, DR_CARRIER_ID FROM DELIVERY_REQUEST WHERE DR_STATE = 'Q' ORDER BY DR_QUEUED");
        dlFindOldestRequest.setMaxRows(1);
        PreparedStatement dlSetRequestState = this.prepareStatement("UPDATE DELIVERY_REQUEST SET DR_STATE = ? WHERE DR_ID = ?");
        PreparedStatement dlCompleteDelivery = this.prepareStatement("UPDATE DELIVERY_REQUEST SET DR_STATE = 'C', DR_COMPLETED = CURRENT TIMESTAMP WHERE DR_ID = ?");
        PreparedStatement dlFindOrderToDeliver = this.prepareStatement("SELECT MIN(NO_O_ID) AS ORDER_TO_DELIVER FROM NEWORDERS WHERE NO_W_ID = ? AND NO_D_ID = ?");
        PreparedStatement dlDeleteNewOrder = this.prepareStatement("DELETE FROM NEWORDERS WHERE NO_W_ID = ? AND NO_D_ID = ? AND NO_O_ID = ?");
        PreparedStatement dlSetOrderCarrier = this.prepareStatement("UPDATE ORDERS SET O_CARRIER_ID = ? WHERE O_W_ID = ? AND O_D_ID = ? AND O_ID = ?");
        PreparedStatement dlSetOrderlineDate = this.prepareStatement("UPDATE ORDERLINE SET OL_DELIVERY_D = CURRENT TIMESTAMP WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?");
        PreparedStatement dlUpdateCustomer = this.prepareStatement("UPDATE CUSTOMER SET C_BALANCE = (SELECT SUM(OL_AMOUNT) FROM ORDERLINE WHERE OL_W_ID = ? AND OL_D_ID = ? AND OL_O_ID = ?), C_DELIVERY_CNT = C_DELIVERY_CNT + 1 WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = (SELECT O_C_ID FROM ORDERS WHERE O_W_ID = ? AND O_D_ID = ? AND O_ID = ?)");
        PreparedStatement dlRecordDelivery = this.prepareStatement("INSERT INTO DELIVERY_ORDERS(DO_DR_ID, DO_D_ID, DO_O_ID) VALUES (?, ?, ?)");
        ResultSet rs = dlFindOldestRequest.executeQuery();
        rs.next();
        int request = rs.getInt("DR_ID");
        short w = rs.getShort("DR_W_ID");
        short carrier = rs.getShort("DR_CARRIER_ID");
        this.reset(dlFindOldestRequest);
        dlSetRequestState.setString(1, "I");
        dlSetRequestState.setInt(2, request);
        dlSetRequestState.executeUpdate();
        this.reset(dlSetRequestState);
        this.conn.commit();
        dlRecordDelivery.setInt(1, request);
        for (short d = 1; d <= 10; d = (short)(d + 1)) {
            dlRecordDelivery.setShort(2, d);
            dlFindOrderToDeliver.setShort(1, w);
            dlFindOrderToDeliver.setShort(2, d);
            rs = dlFindOrderToDeliver.executeQuery();
            rs.next();
            int order = rs.getInt("ORDER_TO_DELIVER");
            if (rs.wasNull()) {
                dlRecordDelivery.setNull(3, 4);
                dlRecordDelivery.addBatch();
            }
            this.reset(dlFindOrderToDeliver);
            dlDeleteNewOrder.setShort(1, w);
            dlDeleteNewOrder.setShort(2, d);
            dlDeleteNewOrder.setInt(3, order);
            dlDeleteNewOrder.executeUpdate();
            this.reset(dlDeleteNewOrder);
            dlSetOrderCarrier.setShort(1, carrier);
            dlSetOrderCarrier.setShort(2, w);
            dlSetOrderCarrier.setShort(3, d);
            dlSetOrderCarrier.setInt(4, order);
            dlSetOrderCarrier.executeUpdate();
            this.reset(dlSetOrderCarrier);
            dlSetOrderlineDate.setShort(1, w);
            dlSetOrderlineDate.setShort(2, d);
            dlSetOrderlineDate.setInt(3, order);
            dlSetOrderlineDate.executeUpdate();
            this.reset(dlSetOrderlineDate);
            dlUpdateCustomer.setShort(1, w);
            dlUpdateCustomer.setShort(2, d);
            dlUpdateCustomer.setInt(3, order);
            dlUpdateCustomer.setShort(4, w);
            dlUpdateCustomer.setShort(5, d);
            dlUpdateCustomer.setShort(6, w);
            dlUpdateCustomer.setShort(7, d);
            dlUpdateCustomer.setInt(8, order);
            dlUpdateCustomer.executeUpdate();
            this.reset(dlUpdateCustomer);
            this.conn.commit();
            dlRecordDelivery.setInt(3, order);
            dlRecordDelivery.addBatch();
        }
        dlRecordDelivery.executeBatch();
        this.reset(dlRecordDelivery);
        dlCompleteDelivery.setInt(1, request);
        dlCompleteDelivery.executeUpdate();
        this.reset(dlCompleteDelivery);
        this.conn.commit();
    }

    public void sortOrderItems(int[] items, short[] quantities, short[] supplyW) {
        int i;
        Object[] list = new OrderItem4Sort[items.length];
        for (i = 0; i < items.length; ++i) {
            list[i] = new OrderItem4Sort(items[i], quantities[i], supplyW[i]);
        }
        Arrays.sort(list);
        for (i = 0; i < items.length; ++i) {
            items[i] = ((OrderItem4Sort)list[i]).i;
            quantities[i] = ((OrderItem4Sort)list[i]).q;
            supplyW[i] = ((OrderItem4Sort)list[i]).w;
        }
    }
}

