/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.utils.DbUtil;

public class TesterObject {
    private String thread_id;
    protected Connection connex = null;
    protected DbUtil dbutil;

    public TesterObject(String name) {
        this.thread_id = name;
        this.dbutil = new DbUtil(this.getThread_id());
        System.out.println("==========> " + this.getThread_id() + " THREAD starting <======");
    }

    public Connection getConnection() {
        Connection conn = null;
        String jdbcurl = "";
        try {
            System.out.println(this.getThread_id() + " is getting a connection to the database...");
            if (NsTest.embeddedMode) {
                jdbcurl = NsTest.embedDbURL + ";" + "bootPassword=12345678";
            } else if (NsTest.driver_type.equalsIgnoreCase("DerbyClient")) {
                jdbcurl = NsTest.clientDbURL + ";" + "bootPassword=12345678";
            }
            System.out.println("-->Thread " + this.getThread_id() + " starting with url " + jdbcurl + " <--");
            conn = DriverManager.getConnection(jdbcurl, NsTest.prop);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("FAIL: " + this.getThread_id() + " could not get the database connection");
            this.printException("Failed getting database connection using " + jdbcurl, e);
        }
        NsTest.addStats(NsTest.CONNECTIONS_MADE, 1);
        System.out.println("Connection number: " + NsTest.numConnections);
        return conn;
    }

    public void setIsolationLevel(int level) {
        try {
            this.connex.setTransactionIsolation(level);
        }
        catch (Exception e) {
            System.out.println("FAIL: " + this.getThread_id() + " could not set isolation level");
            this.printException("setting transaction isolation", e);
        }
    }

    public void closeConnection() {
        try {
            System.out.println(this.getThread_id() + " is closing it's connection to the database...");
            this.connex.close();
        }
        catch (Exception e) {
            System.out.println("FAIL: " + this.getThread_id() + " could not close the database connection");
            this.printException("closing database connection", e);
        }
    }

    public void doIUDOperation() {
        int decider = (int)(Math.random() * 100.0) % 3;
        switch (decider) {
            case 0: {
                try {
                    int numInsert = this.dbutil.add_one_row(this.connex, this.getThread_id());
                    if (numInsert == 1) {
                        NsTest.addStats(NsTest.INSERT, 1);
                        break;
                    }
                    NsTest.addStats(NsTest.FAILED_INSERT, 1);
                }
                catch (Exception e) {
                    this.printException("executing add_one_row()", e);
                }
                break;
            }
            case 1: {
                try {
                    int numUpdate = this.dbutil.update_one_row(this.connex, this.getThread_id());
                    if (numUpdate == 1) {
                        NsTest.addStats(NsTest.UPDATE, 1);
                        break;
                    }
                    NsTest.addStats(NsTest.FAILED_UPDATE, 1);
                }
                catch (Exception e) {
                    this.printException("executing update_one_row", e);
                }
                break;
            }
            case 2: {
                try {
                    int numDelete = this.dbutil.delete_one_row(this.connex, this.getThread_id());
                    if (numDelete == 1) {
                        NsTest.addStats(NsTest.DELETE, 1);
                        break;
                    }
                    NsTest.addStats(NsTest.FAILED_DELETE, 1);
                    break;
                }
                catch (Exception e) {
                    this.printException("executing delete_one_row()", e);
                }
            }
        }
    }

    public int doSelectOperation(int numRowsToSelect) throws SQLException {
        int numRowsSelected = 0;
        ResultSet rSet = null;
        Statement s = null;
        System.out.println(this.getThread_id() + " is selecting " + numRowsToSelect + " rows");
        try {
            s = this.connex.createStatement();
            rSet = s.executeQuery("select id, t_char, t_date, t_decimal, t_decimal_nn, t_double,  t_float, t_int, t_longint, t_numeric_large, t_real, t_smallint, t_time, t_timestamp, t_varchar, serialkey from nstesttab where serialkey <= " + numRowsToSelect);
        }
        catch (Exception e) {
            System.out.println("FAIL: doSelectOperation() had problems creating/executing query");
            this.printException("FAIL: doSelectOperation() had problems creating/executing query", e);
            s.close();
        }
        try {
            while (rSet.next()) {
                int id1 = rSet.getInt(1);
                String str1 = rSet.getString(2);
                Date dt = rSet.getDate(3);
                double doub1 = rSet.getDouble(4);
                double doub2 = rSet.getDouble(5);
                double doub3 = rSet.getDouble(6);
                float flt1 = rSet.getFloat(7);
                int id2 = rSet.getInt(8);
                long lg1 = rSet.getLong(9);
                double doub4 = rSet.getDouble(10);
                float flt2 = rSet.getFloat(11);
                int id3 = rSet.getInt(12);
                Time tm = rSet.getTime(13);
                Timestamp tstmp = rSet.getTimestamp(14);
                String str2 = rSet.getString(15);
                long lg2 = rSet.getLong(16);
                ++numRowsSelected;
            }
            NsTest.addStats(NsTest.SELECT, 1);
            System.out.println(this.thread_id + " selected " + numRowsSelected + " rows");
        }
        catch (Exception e) {
            System.out.println("FAIL: doSelectOperation() had problems working over the ResultSet");
            NsTest.addStats(NsTest.FAILED_SELECT, 1);
            this.printException("processing ResultSet during row data retrieval", e);
            rSet.close();
            s.close();
            System.out.println("Closed the select statement");
        }
        try {
            if (rSet != null && s != null) {
                rSet.close();
                s.close();
                System.out.println("Closed the select statement");
            }
        }
        catch (Exception e) {
            System.out.println("FAIL: doSelectOperation() had problems closing the ResultSet");
            this.printException("closing ResultSet of query to get row data", e);
        }
        return numRowsSelected;
    }

    public void startTesting() {
    }

    public synchronized void printException(String where, Exception e) {
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (se.getSQLState().equals("40001")) {
                System.out.println("TObj --> deadlocked detected");
            }
            if (se.getSQLState().equals("40XL1")) {
                System.out.println("TObj --> lock timeout exception");
            }
            if (se.getSQLState().equals("23500")) {
                System.out.println("TObj --> duplicate key violation");
            }
            if (se.getNextException() != null) {
                String m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
        if (e.getMessage() == null) {
            System.out.println("TObj -->NULL error message detected");
            System.out.println("TObj -->Here is the NULL exception - " + e.toString());
            System.out.println("TObj -->Stack trace of the NULL exception - ");
            e.printStackTrace(System.out);
        }
        System.out.println("TObj -->At this point - " + where + ", exception thrown was : " + e.getMessage());
    }

    public String getTimestamp() {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        return ts.toString();
    }

    public String getThread_id() {
        return this.thread_id;
    }
}

