/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class BankAccountFiller
implements DBFiller {
    static final String ACCOUNT_TABLE = "ACCOUNTS";
    static final String BRANCH_TABLE = "BRANCHES";
    static final String TELLER_TABLE = "TELLERS";
    static final String HISTORY_TABLE = "HISTORY";
    static final int DEFAULT_TELLERS_PER_BRANCH = 10;
    static final int DEFAULT_ACCOUNTS_PER_BRANCH = 100000;
    private static final int ACCOUNT_EXTRA = 84;
    private static final int BRANCH_EXTRA = 88;
    private static final int TELLER_EXTRA = 84;
    static final int HISTORY_EXTRA = 18;
    private final int branches;
    private final int tellersPerBranch;
    private final int accountsPerBranch;

    public BankAccountFiller(int branches, int tellersPerBranch, int accountsPerBranch) {
        if (branches <= 0 || tellersPerBranch <= 0 || accountsPerBranch <= 0) {
            throw new IllegalArgumentException("all arguments must be greater than 0");
        }
        this.branches = branches;
        this.tellersPerBranch = tellersPerBranch;
        this.accountsPerBranch = accountsPerBranch;
    }

    public BankAccountFiller(int scale) {
        this(scale, 10, 100000);
    }

    public void fill(Connection c) throws SQLException {
        c.setAutoCommit(false);
        BankAccountFiller.dropTables(c);
        BankAccountFiller.createTables(c);
        this.fillTables(c);
    }

    private static void dropTables(Connection c) throws SQLException {
        WisconsinFiller.dropTable(c, ACCOUNT_TABLE);
        WisconsinFiller.dropTable(c, BRANCH_TABLE);
        WisconsinFiller.dropTable(c, TELLER_TABLE);
        WisconsinFiller.dropTable(c, HISTORY_TABLE);
        c.commit();
    }

    private static void createTables(Connection c) throws SQLException {
        Statement s = c.createStatement();
        s.executeUpdate("CREATE TABLE ACCOUNTS(ACCOUNT_ID INT PRIMARY KEY, BRANCH_ID INT NOT NULL, ACCOUNT_BALANCE BIGINT NOT NULL, EXTRA_DATA CHAR(84) NOT NULL)");
        s.executeUpdate("CREATE TABLE BRANCHES(BRANCH_ID INT PRIMARY KEY, BRANCH_BALANCE BIGINT NOT NULL, EXTRA_DATA CHAR(88) NOT NULL)");
        s.executeUpdate("CREATE TABLE TELLERS(TELLER_ID INT PRIMARY KEY, BRANCH_ID INT NOT NULL, TELLER_BALANCE INT NOT NULL, EXTRA_DATA CHAR(84) NOT NULL)");
        s.executeUpdate("CREATE TABLE HISTORY(ACCOUNT_ID INT NOT NULL, TELLER_ID INT NOT NULL, BRANCH_ID INT NOT NULL, AMOUNT BIGINT NOT NULL, TIME_STAMP TIMESTAMP NOT NULL, EXTRA_DATA CHAR(18) NOT NULL)");
        s.close();
        c.commit();
    }

    private void fillTables(Connection c) throws SQLException {
        PreparedStatement atIns = c.prepareStatement("INSERT INTO ACCOUNTS(ACCOUNT_ID, BRANCH_ID, ACCOUNT_BALANCE, EXTRA_DATA) VALUES (?, ?, 0, ?)");
        atIns.setString(3, BankAccountFiller.createJunk(84));
        for (int id = 0; id < this.accountsPerBranch * this.branches; ++id) {
            atIns.setInt(1, id);
            atIns.setInt(2, id / this.accountsPerBranch);
            atIns.executeUpdate();
        }
        atIns.close();
        c.commit();
        PreparedStatement btIns = c.prepareStatement("INSERT INTO BRANCHES(BRANCH_ID, BRANCH_BALANCE, EXTRA_DATA) VALUES (?, 0, ?)");
        btIns.setString(2, BankAccountFiller.createJunk(88));
        for (int id = 0; id < this.branches; ++id) {
            btIns.setInt(1, id);
            btIns.executeUpdate();
        }
        btIns.close();
        c.commit();
        PreparedStatement ttIns = c.prepareStatement("INSERT INTO TELLERS(TELLER_ID, BRANCH_ID, TELLER_BALANCE, EXTRA_DATA) VALUES (?, ?, 0, ?)");
        ttIns.setString(3, BankAccountFiller.createJunk(84));
        for (int id = 0; id < this.tellersPerBranch * this.branches; ++id) {
            ttIns.setInt(1, id);
            ttIns.setInt(2, id / this.tellersPerBranch);
            ttIns.executeUpdate();
        }
        ttIns.close();
        c.commit();
    }

    static String createJunk(int length) {
        char[] junk = new char[length];
        Arrays.fill(junk, 'x');
        return new String(junk);
    }
}

