/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;

public class SelectDistinctTest
extends JDBCPerfTestCase {
    private PreparedStatement ps;
    private static final String TEST_CHAR5 = "selectDistinctChar5";
    private static final int EXPECTED_DISTINCT_CHAR5 = 120;
    private static final String TEST_BINARY5 = "selectDistinctBinary5";
    private static final int EXPECTED_DISTINCT_BINARY5 = 120;
    static /* synthetic */ Class class$org$apache$derbyTesting$perf$basic$jdbc$SelectDistinctTest;

    private SelectDistinctTest(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SelectDistinctTest");
        suite.addTest((Test)new SelectDistinctTest(TEST_CHAR5, 2000, 4));
        suite.addTest((Test)new SelectDistinctTest(TEST_BINARY5, 2000, 4));
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE TABLE selectDistinctChar5(COL CHAR(5))");
                s.execute("INSERT INTO selectDistinctChar5 SELECT V1.X||V2.X||V3.X||V4.X||V5.X FROM (VALUES 'A', 'B', 'C', 'D', 'E') V1(X), (VALUES 'A', 'B', 'C', 'D', 'E') V2(X), (VALUES 'A', 'B', 'C', 'D', 'E') V3(X), (VALUES 'A', 'B', 'C', 'D', 'E') V4(X), (VALUES 'A', 'B', 'C', 'D', 'E') V5(X) WHERE (SELECT COUNT(*) FROM (VALUES 'A', 'B', 'C', 'D', 'E') VV(X) WHERE VV.X NOT IN (V1.X,V2.X,V3.X,V4.X,V5.X)) = 0");
                for (int i = 0; i < 3; ++i) {
                    s.execute("INSERT INTO selectDistinctChar5 SELECT * FROM selectDistinctChar5");
                }
                s.execute("CREATE TABLE selectDistinctBinary5(COL CHAR(5) FOR BIT DATA)");
                s.execute("CREATE FUNCTION CHAR_TO_BINARY(STR CHAR(5)) RETURNS CHAR(5) FOR BIT DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + (class$org$apache$derbyTesting$perf$basic$jdbc$SelectDistinctTest == null ? (class$org$apache$derbyTesting$perf$basic$jdbc$SelectDistinctTest = SelectDistinctTest.class$("org.apache.derbyTesting.perf.basic.jdbc.SelectDistinctTest")) : class$org$apache$derbyTesting$perf$basic$jdbc$SelectDistinctTest).getName() + ".charToBinary' NO SQL");
                s.execute("INSERT INTO selectDistinctBinary5 SELECT CHAR_TO_BINARY(COL) FROM selectDistinctChar5");
            }
        };
    }

    protected void setUp() throws SQLException {
        this.ps = this.prepareStatement("SELECT DISTINCT * FROM " + this.getName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ps = null;
    }

    public static byte[] charToBinary(String s) throws UnsupportedEncodingException {
        return s.getBytes("UTF-8");
    }

    public void selectDistinctChar5() throws SQLException {
        JDBC.assertDrainResults(this.ps.executeQuery(), 120);
    }

    public void selectDistinctBinary5() throws SQLException {
        JDBC.assertDrainResults(this.ps.executeQuery(), 120);
    }
}

