/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class BaseLoad100TestSetup
extends CleanDatabaseTestSetup {
    protected int rowsToLoad = 10000;
    protected String tableName = "BASELOAD100";

    public BaseLoad100TestSetup(Test test) {
        super(test);
    }

    public BaseLoad100TestSetup(Test test, int rowsToLoad) {
        super(test);
        this.rowsToLoad = rowsToLoad;
    }

    public BaseLoad100TestSetup(Test test, String tableName) {
        super(test);
        this.tableName = tableName;
    }

    public BaseLoad100TestSetup(Test test, int rowsToLoad, String tableName) {
        super(test);
        this.tableName = tableName;
        this.rowsToLoad = rowsToLoad;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement insert = conn.prepareStatement("INSERT INTO " + this.tableName + " VALUES ( ?,?,?,?,?,?,?,?,? )");
        this.loadData(insert);
        insert.close();
        conn.close();
    }

    protected void decorateSQL(Statement s) throws SQLException {
        s.execute("CREATE TABLE " + this.tableName + " (" + "i1 INT, i2 INT, i3 INT, i4 INT, i5 INT, " + "c6 CHAR(20), c7 CHAR(20), c8 CHAR(20), c9 CHAR(20))");
    }

    private void loadData(PreparedStatement insert) throws Exception {
        for (int i = 0; i < this.rowsToLoad; ++i) {
            insert.setInt(1, i);
            insert.setInt(2, 2);
            if (i % 100 == 57) {
                insert.setInt(3, 436);
            } else {
                insert.setInt(3, 2);
            }
            insert.setInt(4, 2);
            insert.setInt(5, i);
            insert.setString(6, "01234567890123456789");
            if (i % 100 == 34) {
                insert.setString(7, "012345javaone6789");
            } else {
                insert.setString(7, "01234567890123456789");
            }
            insert.setString(8, "01234567890123456789");
            insert.setString(9, i + 1000 + "0123456789012");
            insert.executeUpdate();
        }
        insert.getConnection().commit();
    }
}

