/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.XADataSource;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XADataSourceConnector
implements Connector {
    private TestConfiguration config;
    private XADataSource ds;

    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = J2EEDataSource.getXADataSource(config, null);
    }

    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getXAConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS("createDatabase", "create").getXAConnection().getConnection();
        }
    }

    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getXAConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            XADataSource tmpDs = this.singleUseDS("createDatabase", "create");
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getXAConnection().getConnection();
        }
    }

    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getXAConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS("createDatabase", "create").getXAConnection(user, password).getConnection();
        }
    }

    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getXAConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            XADataSource tmpDs = this.singleUseDS("createDatabase", "create");
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getXAConnection(user, password).getConnection();
        }
    }

    public void shutDatabase() throws SQLException {
        this.singleUseDS("shutdownDatabase", "shutdown").getXAConnection().getConnection();
    }

    public void shutEngine() throws SQLException {
        Assert.fail((String)"shutdown engine not implemened");
    }

    private XADataSource singleUseDS(String property, String value) throws SQLException {
        HashMap hm = JDBCDataSource.getDataSourceProperties(this.config);
        hm.put(property, value);
        XADataSource sds = J2EEDataSource.getXADataSource(this.config, hm);
        return sds;
    }
}

