/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceConnector
implements Connector {
    private TestConfiguration config;
    private DataSource ds;

    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = JDBCDataSource.getDataSource(config, null);
    }

    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS("createDatabase", "create").getConnection();
        }
    }

    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            DataSource tmpDs = this.singleUseDS("createDatabase", "create");
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getConnection();
        }
    }

    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getConnection(user, password);
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS("createDatabase", "create").getConnection(user, password);
        }
    }

    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getConnection(user, password);
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            DataSource tmpDs = this.singleUseDS("createDatabase", "create");
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getConnection(user, password);
        }
    }

    public void shutDatabase() throws SQLException {
        this.singleUseDS("shutdownDatabase", "shutdown").getConnection();
    }

    public void shutEngine() throws SQLException {
        DataSource tmpDs = this.singleUseDS("shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(tmpDs, "databaseName", "");
        tmpDs.getConnection();
    }

    private DataSource singleUseDS(String property, String value) throws SQLException {
        HashMap hm = JDBCDataSource.getDataSourceProperties(this.config);
        hm.put(property, value);
        DataSource sds = JDBCDataSource.getDataSource(this.config, hm);
        return sds;
    }
}

